/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   errormenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: displays an error message for some time, and then goes
 *              automatically back to the parent menu
 */


/*---------------------------------------------------------------------------
  includes
  ---------------------------------------------------------------------------*/

#include "errormenu.h"
#include "text.h"
#include "macro.h"
#include "log.h"
#include "time.h"

/*---------------------------------------------------------------------------
  constants
  ---------------------------------------------------------------------------*/

#define U61_ERRORMENU_DELAY_SEC 3

/*---------------------------------------------------------------------------
  functions
  ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of the error menu
 */ 
U61_ErrorMenu::U61_ErrorMenu(U61_Menu *parent, char *err) 
  : U61_Menu(parent, "Error")
{
  U61_MACRO_STRCPY(error,err);

  time_limit=0;
}

/*--------------------------------------------------------------------------*/
/*
 * called the first time the menu is drawn
 */
void U61_ErrorMenu::before_first_draw()
{
  U61_LOG_DEBUG(error);

  add_item(new U61_Text(error));
  select(0);

  time_limit=U61_Time::for_effect()+U61_ERRORMENU_DELAY_SEC*U61_TIME_ONE_SECOND;
}

/*--------------------------------------------------------------------------*/
/*
 * called on a regular basis
 */
U61_Menu *U61_ErrorMenu::poll()
{
  U61_Menu *next_menu;

  next_menu=this;

  if (0<time_limit && time_limit<U61_Time::for_effect())
    {
      next_menu=back();
    }
  
  return next_menu;
}
