/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   event.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: one of the most fundamental classes of U61. An event is
 *              basically what u61 uses to control a map and send info
 *              to other computers on the network. There's a difference
 *              between U61_Event and CL_Event. CL_Event is GUI oriented
 *              for it's associated to a mouse click, a key press etc...
 *              but U61_Event is very U61 specific since it can be a
 *              drop action or a curse request.
 *              almost all events are dated.
 */

#ifndef U61_INC_EVENT
#define U61_INC_EVENT

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>
//#include <iostream.h>

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

/*
 * The list of event codes
 */
#define U61_EVENT_NOTHING            0

#define U61_EVENT_READY              1
#define U61_EVENT_READY_ALL          2

#define U61_EVENT_START_STOP         3
#define U61_EVENT_KILL               4

#define U61_EVENT_NAME_LETTER        5
#define U61_EVENT_CHAT_LETTER        6
#define U61_EVENT_CHANGE_BACKGROUND  7

#define U61_EVENT_MOVE_LEFT          8
#define U61_EVENT_MOVE_RIGHT         9
#define U61_EVENT_ROTATE_LEFT       10
#define U61_EVENT_ROTATE_RIGHT      11
#define U61_EVENT_MOVE_DOWN         12
#define U61_EVENT_DROP              13
#define U61_EVENT_SET_VICTIM        14
#define U61_EVENT_NEXT_VICTIM       15
#define U61_EVENT_PREV_VICTIM       16
#define U61_EVENT_USE_ANTIDOTE      17
 
#define U61_EVENT_NEW_BLOCK         18
#define U61_EVENT_LOOSE             19
#define U61_EVENT_NEW_CURSE         20
#define U61_EVENT_REQUEST_CURSE     21
#define U61_EVENT_DO_CURSE          22

#define U61_EVENT_HISTORY_BEGIN     23
#define U61_EVENT_HISTORY_END       24

#define U61_EVENT_SERIAL_BEGIN      25
#define U61_EVENT_SERIAL_DATA       26
#define U61_EVENT_SERIAL_END        27

#define U61_EVENT_REQUEST_CHECKSUM  28
#define U61_EVENT_VERIFY_CHECKSUM   29

/*
 * The size (in bytes) of a serialized event
 */
#define U61_EVENT_SERIALIZED_SIZE    8

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Event
{ 
 public:
  U61_Event();
  ~U61_Event();
 
  unsigned int code : 8;
  unsigned int author : 4;
  unsigned int target : 4;
  unsigned int par : 16;
  unsigned int time : 32;

  bool serialize(unsigned char **buffer, unsigned char *buffer_limit);
  bool unserialize(unsigned char **buffer, unsigned char *buffer_limit);
  
 protected:  
};

ostream &operator <<(ostream &o, U61_Event evt);

#endif
