/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   eventcopy.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: abstract class. its subclasses may be used to transmit
 *              information to other players. basically, a map/player is
 *              associated to an eventcopy instance. all events are send to
 *              the eventcopy, which if and to who the events should be
 *              transmitted
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "eventcopy.h"
#include "log.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/

#define U61_EVENTCOPY_DUMMY_PASS 10

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of an event copy object
 */ 
U61_EventCopy::U61_EventCopy(int player_id)
{
  dummy_counter=0;
  player=player_id;
}

/*--------------------------------------------------------------------------*/
/* 
 * destruction of an event copy object
 */ 
U61_EventCopy::~U61_EventCopy()
{

}

/*--------------------------------------------------------------------------*/
/*
 * flushes the events, this function does nothing, since the class is
 * a virtual one. this function is the only one that depends on the nature
 * of the event source
 */
void U61_EventCopy::flush()
{
    
}

/*--------------------------------------------------------------------------*/
/*
 * clears the event list
 */
void U61_EventCopy::clear()
{
  queue.clear();
}

/*--------------------------------------------------------------------------*/
/*
 * returns true if no events are available
 */
bool U61_EventCopy::empty()
{
  return queue.empty();
}

/*--------------------------------------------------------------------------*/
/*
 * puts an event in the queue
 */
void U61_EventCopy::put(U61_Event event)
{
  /*
   * If an event does not come from the right player, we do not let
   * it pass...
   * We also block 90% of NOTHING events, for they would waste bandwidth
   */
  if (event.author==(unsigned int) player)
    {
      switch (event.code)
	{
	case U61_EVENT_NOTHING:
	  if (dummy_counter>=U61_EVENTCOPY_DUMMY_PASS)
	    { 
	      queue.push_back(event);
	      dummy_counter=0;
	    }
	  dummy_counter++;	  
	  break;
	case U61_EVENT_READY_ALL:
	  /*
	   * We do not copy this event otherwise it replicates
	   * forever on the network...
	   */
	  break;
	default:
	  U61_LOG_DEBUG("Copying event "<<event);
	  queue.push_back(event);
	  break;
	}
    }
}




