/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   eventsource.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: abstract class. its subclasses are used to retrieve
 *              events for a map. a map is associated to an eventsource
 *              which may gather information from the keyboard or the
 *              network, it just depends
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "eventsource.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of an event source
 */ 
U61_EventSource::U61_EventSource()
{
    reset();
}

/*--------------------------------------------------------------------------*/
/* 
 * destruction of an evenbt source
 */ 
U61_EventSource::~U61_EventSource()
{

}

/*--------------------------------------------------------------------------*/
/*
 * polls the events, this function does nothing, since the class is
 * a virtual one. this function is the only one that depends on the nature
 * of the event source
 */
void U61_EventSource::poll()
{
    
}

/*--------------------------------------------------------------------------*/
/*
 * resets & clears the event list
 */
void U61_EventSource::reset()
{
    last_time_used=0;
    queue.clear();
    ready=false;
}

/*--------------------------------------------------------------------------*/
/*
 * returns true if no events are available
 */
bool U61_EventSource::empty()
{
    return queue.empty();
}

/*--------------------------------------------------------------------------*/
/*
 * retrives the next event in the queue, and deletes it from the queue
 */
U61_Event U61_EventSource::get()
{
    U61_Event event;

    event=queue.front();
    queue.pop_front();

    return event;
}

/*--------------------------------------------------------------------------*/
/*
 * retrives the next event in the queue, but doesn't remove it from the queue
 */
U61_Event U61_EventSource::check()
{
    U61_Event event;

    event=queue.front();

    return event;
}

/*--------------------------------------------------------------------------*/
/*
 * puts an event in the queue
 * there are *very* simple but important checking about the time
 * of the event. this way, we can garantee at 100% that there's never
 * an event dated 103 after an event dated 104
 * good thing
 */
void U61_EventSource::put(U61_Event evt)
{
  if (evt.time<last_time_used)
    {
      evt.time=last_time_used;
    }
  else
    {
      last_time_used=evt.time;
    }

  /*
   * Now we put the event in the queue only if we have received
   * the "READY_ALL" event at least once. This is usefull to
   * wait until all players are ready in network games
   */
  if (ready || 
      evt.code==U61_EVENT_NOTHING ||
      evt.code==U61_EVENT_NAME_LETTER ||
      evt.code==U61_EVENT_CHAT_LETTER ||
      evt.code==U61_EVENT_READY ||
      evt.code==U61_EVENT_READY_ALL)
    {
      if (evt.code==U61_EVENT_READY_ALL)
	{
	  ready=true;
	}

      queue.push_back(evt);
    }
}

