/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   file.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: This menu item allows the user to choose a file.
 *              This includes theme files and script files.
 *              The file can be a release file or a local user file
 *              The select function of this function just sets a string
 *              to the chosen filename. It's important to note that the
 *              displayed string is not necessary the file name. This
 *              allow to use the same filename for release/user files.
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <string.h>

#include "file.h"
#include "macro.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a 'file' item
 */ 
U61_File::U61_File(char *label, char *name, 
		   char buf[U61_CONST_STRING_SIZE]) : U61_MenuItem()
{
  buffer=buf;
  U61_MACRO_STRCPY(filename,name);
  set_text(label);
}

/*--------------------------------------------------------------------------*/
/*
 * select function, it sets the global buffer to the right value
 */
void U61_File::select(int pos)
{
  U61_MACRO_STRNCPY(buffer,filename,U61_CONST_STRING_SIZE);

  U61_MenuItem::select(pos);    
}
