/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   findgamemenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: menu used to find and select games automatically by
 *              querying the meta-server on www.ufoot.org. 
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "joinmenu.h"
#include "networkmenu.h"
#include "nonpausingmenu.h"
#include "findgamemenu.h"
#include "gameinfomenu.h"
#include "gameinfo.h"
#include "button.h"
#include "editaddress.h"
#include "global.h"
#include "savescriptmenu.h"
#include "scoremenu.h"
#include "log.h"
#include "text.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of the menu
 */ 
U61_FindGameMenu::U61_FindGameMenu(U61_Menu *parent)
  : U61_Menu(parent,"Available servers")
{
  update_needed = false;

  /*
   * Normally this item is never displayed but one never knows,
   * search() might return false, so we are carefull.
   */
  add_item(new U61_Text("Please wait..."));
  select(0);

  if (www_list.search(true))
    {
      search_started(); 
    }
}

/*--------------------------------------------------------------------------*/
/*
 * performs an action, since a key press has been recorded
 */
U61_Menu *U61_FindGameMenu::validate()
{
  U61_Menu *next_menu;

  /*
   * If we get here, it's because the user pressed enter on a text
   * item such as "searching" or on the "Refresh" button. Indeed, 
   * GameInfo items handle the validate function directly, so
   * this function is not called in this case.
   */

  if (!www_list.is_searching())
    {
      /*
       * We force a new search.
       */
      if (www_list.search(true))
	{
	  search_started();
	}      
    }

  next_menu=this;

  return next_menu;
}

/*--------------------------------------------------------------------------*/
/*
 * fired when the user presses escape to go back in the menu history
 */
U61_Menu *U61_FindGameMenu::back()
{
  U61_Menu *new_menu;

  if (!www_list.is_searching())
    {
      new_menu=U61_Menu::back();
    }
  else
    {
      /*
       * We cancel the search and return the default menu
       */
      www_list.cancel();
      new_menu=this;
    }

  return new_menu;
}

/*--------------------------------------------------------------------------*/
/*
 * This function is called on a regular basis, and is used to automatically
 * refresh the server list
 */
U61_Menu *U61_FindGameMenu::poll()
{
  U61_Menu *new_menu;

  new_menu=U61_Menu::poll();

  if (!www_list.is_searching())
    {
      if (update_needed)
      	{
	  search_done();
	}
      else
	{
	  /*
	   * Since we do not force the search, it will be started only some
	   * time after the first one is over.
	   */
	  if (www_list.search(false))
	    {
	      search_started();
	    }
	}
    }

  return new_menu;
}

/*--------------------------------------------------------------------------*/
/*
 * Clears the menu when a search has been started
 */
void U61_FindGameMenu::search_started()
{
  remove_items();

  add_item(new U61_Text("Searching..."));
  select(0);

  update_needed = true;
}

/*--------------------------------------------------------------------------*/
/*
 * Updates the menu when a search is over
 */
void U61_FindGameMenu::search_done()
{
  int i,size;

  remove_items();

  size=www_list.get_size();

  add_item(new U61_Button("Refresh"));

  if (size>0) 
    {
      for (i=0;i<size;++i)
	{
	  add_item(new U61_GameInfo(this,www_list.get_item(i)));
	}

      /* 
       * We select the first server, and not the "Refresh" button
       */
      select(1);
    }
  else
    {
      select(0);
    }

  update_needed = false;
}
