/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   gameinfo.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: menu item used to hold informations about a server game,
 *              such as its address, the number of connected players, etc...
 */ 


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "gameinfo.h"
#include "gameinfomenu.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a game info item
 */ 
U61_GameInfo::U61_GameInfo(U61_Menu *m, U61_WwwListItem *i) : U61_MenuItem(i->get_address())
{
  menu = m;
  info = i;
}

/*--------------------------------------------------------------------------*/
/*
 * validation of the menu (ie click on ENTER)
 */
U61_Menu *U61_GameInfo::validate()
{
  U61_GameInfoMenu *new_menu;

  new_menu = new U61_GameInfoMenu(menu,info);

  return new_menu;
}


