/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   gameinfomenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: menu used to give informations about a network game before
 *              the user actually decides to join it.
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "gameinfomenu.h"
#include "nonpausingmenu.h"
#include "networkmenu.h"
#include "savescriptmenu.h"
#include "scoremenu.h"
#include "button.h"
#include "global.h"
#include "log.h"
#include "text.h"
#include "macro.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of the menu
 */ 
U61_GameInfoMenu::U61_GameInfoMenu(U61_Menu *parent, U61_WwwListItem *i)
  : U61_Menu(parent,"Game information")
{
  char buffer[U61_CONST_STRING_SIZE];
  info = i;

  add_item(new U61_Button("Join now"));

  U61_MACRO_SPRINTF1(buffer,"Address : %s",info->get_address());
  add_item(new U61_Text(buffer));

  U61_MACRO_SPRINTF1(buffer,"Port : %d",info->get_port());
  add_item(new U61_Text(buffer));

  format_delay(buffer,info->get_uptime());
  add_item(new U61_Text(buffer));

  U61_MACRO_SPRINTF2(buffer,"Players : %d/%d",info->get_busy_players(),info->get_max_players());
  add_item(new U61_Text(buffer));

  U61_MACRO_STRCPY(buffer,"Password : ");
  if (info->get_password())
    {
      U61_MACRO_STRCAT(buffer,"yes");
    }
  else
    {
      U61_MACRO_STRCAT(buffer,"no");
    }
  add_item(new U61_Text(buffer));

  U61_MACRO_SPRINTF1(buffer,"Comment : %s",info->get_comment());
  add_item(new U61_Text(buffer));

  select(0);
}

/*--------------------------------------------------------------------------*/
/*
 * performs an action, since a key press has been recorded
 */
U61_Menu *U61_GameInfoMenu::validate()
{
  U61_Menu *next_menu;

  next_menu=this;

  switch (selection)
    {
    case 0:
      U61_MACRO_STRCPY(U61_Global::config.server_id,info->get_address());
      U61_Global::config.network_port=info->get_port();

      next_menu=new U61_NonPausingMenu
	(new U61_NetworkMenu
	 (new U61_SaveScriptMenu
	  (new U61_ScoreMenu(this))));
      U61_Global::game.start_network_join();
      break;
    }

  return next_menu;
}

/*--------------------------------------------------------------------------*/
/*
 * this function does nothing, this way "beeps" are removed and the 
 * "Join now" button is always selected.
 */
void U61_GameInfoMenu::select_up()
{
    
}

/*--------------------------------------------------------------------------*/
/*
 * this function does nothing, this way "beeps" are removed and the 
 * "Join now" button is always selected.
 */
void U61_GameInfoMenu::select_down()
{
    
}

/*--------------------------------------------------------------------------*/
/*
 * Formats a time in second to a string
 */
void U61_GameInfoMenu::format_delay(char buf[U61_CONST_STRING_SIZE], int sec)
{
  int days,hours,minutes,seconds;
  char buf2[U61_CONST_STRING_SIZE];

  seconds=sec%60;
  minutes=(sec/60)%60;
  hours=(sec/3600)%24;
  days=(sec/(24*3600));
  if (days>0)
    {
      if (days>1)
	{
	  U61_MACRO_SPRINTF1(buf2,
			    "Uptime : %d days",
			    days)
	}
      else
	{
	  U61_MACRO_SPRINTF0(buf2,
			     "Uptime : 1 day");
	}
    }
  else if (hours>0)
    {
      U61_MACRO_SPRINTF1(buf2,
			 "Uptime : %d h",
			 hours);
    }
  else if (minutes>0)
    {
      U61_MACRO_SPRINTF1(buf2,
	      "Uptime : %d min",
			minutes);
    }
  else
    {
      U61_MACRO_SPRINTF1(buf2,
	      "Uptime : %d sec",
			seconds);
    }

  U61_MACRO_STRNCPY(buf,buf2,U61_CONST_STRING_SIZE);
}
