/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   global.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a class which contains static objects which are meant to
 *              be used as global data. for instance, the config and data
 *              are stored in this class. it's interesting to have
 *              this class static and keep config and data not static,
 *              for this way it's possible to load several config/data set
 *              and then choose to use one or another
 */

#ifndef U61_INC_GLOBAL
#define U61_INC_GLOBAL

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "config.h"
#include "data.h"
#include "game.h"
#include "layout.h"
#include "remotescript.h"
#include "inputmonitor.h"
#include "mousemonitor.h"
#include "score.h"
#include "systeminfo.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Global
{
public:
    static U61_Config config;
    static U61_Data data;
    static U61_Game game;
    static U61_Layout layout;
    static U61_RemoteScript remote_script;
    static U61_InputMonitor input_monitor;
    static U61_MouseMonitor mouse_monitor;
    static U61_Score score;
    static U61_SystemInfo system_info;
protected:
};

#endif
