/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   http.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: utilities to handle basic http requests. Used for
 *              interaction with the meta-server.
 */



#ifndef U61_INC_HTTP
#define U61_INC_HTTP

/*---------------------------------------------------------------------------
  includes
  ---------------------------------------------------------------------------*/

#include "const.h"

/*---------------------------------------------------------------------------
  constants
  ---------------------------------------------------------------------------*/

#define U61_HTTP_REQUEST_SIZE   1000
#define U61_HTTP_ANSWER_SIZE  100000
#define U61_HTTP_ANSWER_OK      "OK"

/*---------------------------------------------------------------------------
  classes
  ---------------------------------------------------------------------------*/

class U61_Http
{
 public:
  U61_Http(char *h=NULL, int p=0, char *r=NULL);
  ~U61_Http();
    
  void reset();
  void set_host(char *h);
  void set_port(int p);
  void set_request(char *r);
  bool execute();
  char *get_answer();

  static void format_url_param(char dst[U61_CONST_STRING_SIZE], char *src);

  static void parser_skip_space(char **str);
  static bool parser_read_string(char *result,char **str,int size);
  static bool parser_read_int(int *result,char **str);
  static bool parser_read_separator(char **str);
  static bool parser_read_eol(char **str);
  static void parser_next_line(char **str);

 protected:
  char host[U61_CONST_STRING_SIZE];
  int port;
  char request[U61_HTTP_REQUEST_SIZE+1];
  char answer[U61_HTTP_ANSWER_SIZE+1]; 
};

#endif



