/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   input.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this class is used to retrieve information from the keyboard
 *              it is basically an array of keys which can be polled
 *              the interesting point is that an input object may listen
 *              only a reduced number of keys (for instance the keys
 *              associated to a player). this way keys are automatically
 *              sorted, one can say player 1 is associated to keys 
 *              'A' 'B' and 'C' and be sure that this does not interfere 
 *              with other players input
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "input.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of an input object
 */ 
U61_Input::U61_Input(int size)
{
  keys_size=size;
  keys=new U61_Key[keys_size];
}

/*--------------------------------------------------------------------------*/
/* 
 * destruction of an input object
 */ 
U61_Input::~U61_Input()
{

}

/*--------------------------------------------------------------------------*/
/*
 * sets the number of keys to use for this input provider
 */
void U61_Input::set_key(int index,U61_Key key)
{
    keys[index]=key;
}

/*--------------------------------------------------------------------------*/
/*
 * polls all the key presses
 * because of the way key presses and especially the repeat behavior
 * are coded, the following might happen:
 * key A is pressed at time 5, starts repeating
 * key B is pressed at time 14, starts repeating
 * then for a while, key A is always at time n*10+5 and B at time n*10+4
 * so it might happen than key A and B are found to be pressed at time
 * 99, however, since the keys are repeating, the events are dated 95 & 94
 * then we poll A before B (since A's keycode is before B's), so we get
 * a 95 dated event fired before a 94 dated -> bug
 * this is corrected later in the U61_LocalSource, where event dates
 * are changed so that everything keeps coherent
 */
void U61_Input::poll(unsigned int time)
{
    int i;
    U61_Event evt;
    last_poll_time = time;

    for (i=0;i<keys_size;++i)
    {
        keys[i].poll(time);
        while(!(keys[i].empty()))
	{
            evt=keys[i].get();
            queue.push_back(evt);
	}
    }
}

/*--------------------------------------------------------------------------*/
/*
 * resets the input object
 */
void U61_Input::reset()
{
    int i;

    last_poll_time=0;
    for (i=0;i<keys_size;++i)
    {
        keys[i].reset();
    }
    queue.clear();
}

/*--------------------------------------------------------------------------*/
/*
 * returns true if there are no events pending
 */
bool U61_Input::empty()
{
    return queue.empty();
}

/*--------------------------------------------------------------------------*/
/*
 * returns the last event in the queue
 */
U61_Event U61_Input::get()
{
    U61_Event event;

    event=queue.front();
    queue.pop_front();

    return event;
}

/*--------------------------------------------------------------------------*/
/*
 * Simulates a key press
 */
void U61_Input::simulate(int code)
{
  U61_Event evt;

  evt.code=code;
  evt.time=last_poll_time;

  queue.push_back(evt);
}

