/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   macro.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this file contains some usefull macros which are used
 *              potentially anywhere in the code.
 */

#ifndef U61_INC_MACRO
#define U61_INC_MACRO

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <string.h>

#ifdef U61_DEF_SNPRINTF
#include "../utils/snprintf/snprintf.h"
#endif

/*---------------------------------------------------------------------------
 defines
 ---------------------------------------------------------------------------*/

#define U61_MACRO_MEMSET0(BUFFER) { memset((BUFFER),0,sizeof(BUFFER)); }

#define U61_MACRO_STRNCPY(DST,SRC,SIZE) { memset((DST),0,(SIZE)); strncpy((DST),(SRC),(SIZE)-1); (DST)[(SIZE)-1]='\0'; }
#define U61_MACRO_STRCPY(DST,SRC) { U61_MACRO_STRNCPY((DST),(SRC),sizeof(DST)); }

#define U61_MACRO_STRNCAT(DST,SRC,SIZE) { int len,pos; pos=strlen(DST); len=(SIZE)-1-pos; if (len>0) { int end; strncat((DST),(SRC),len); end = pos+strlen(SRC); if (end<(int) ((SIZE)-1)) { (DST)[end]='\0'; } } (DST)[(SIZE)-1]='\0'; }
#define U61_MACRO_STRCAT(DST,SRC) { U61_MACRO_STRNCAT((DST),(SRC),sizeof(DST)); }

/*
 * GCC 3.0 supports "..." parameters, together with __VA_ARGS__, however
 * GCC 2.95 does not seem to support it. Since we want U61 to be 
 * "GCC 2.95 friendly" we do not use this stuff. It's in C99 however...
 * So that's why there are zillion macros depending on how many args are
 * provided to the snprintf function. 8-(
 */
#define U61_MACRO_SNPRINTF0(DST,SIZE,FMT) { U61_MACRO_STRNCPY((DST),(FMT),(SIZE)); }
#define U61_MACRO_SNPRINTF1(DST,SIZE,FMT,A) { memset((DST),0,(SIZE)); snprintf((DST),(SIZE),(FMT),(A)); (DST)[(SIZE)-1]='\0'; }
#define U61_MACRO_SNPRINTF2(DST,SIZE,FMT,A,B) { memset((DST),0,(SIZE)); snprintf((DST),(SIZE),(FMT),(A),(B)); (DST)[(SIZE)-1]='\0'; }
#define U61_MACRO_SNPRINTF3(DST,SIZE,FMT,A,B,C) { memset((DST),0,(SIZE)); snprintf((DST),(SIZE),(FMT),(A),(B),C); (DST)[(SIZE)-1]='\0'; }
#define U61_MACRO_SNPRINTF4(DST,SIZE,FMT,A,B,C,D) { memset((DST),0,(SIZE)); snprintf((DST),(SIZE),(FMT),(A),(B),C,(D)); (DST)[(SIZE)-1]='\0'; }
#define U61_MACRO_SNPRINTF5(DST,SIZE,FMT,A,B,C,D,E) { memset((DST),0,(SIZE)); snprintf((DST),(SIZE),(FMT),(A),(B),C,(D),(E)); (DST)[(SIZE)-1]='\0'; }
#define U61_MACRO_SNPRINTF6(DST,SIZE,FMT,A,B,C,D,E,F) { memset((DST),0,(SIZE)); snprintf((DST),(SIZE),(FMT),(A),(B),C,(D),(E),(F)); (DST)[(SIZE)-1]='\0'; }
#define U61_MACRO_SNPRINTF7(DST,SIZE,FMT,A,B,C,D,E,F,G) { memset((DST),0,(SIZE)); snprintf((DST),(SIZE),(FMT),(A),(B),C,(D),(E),(F),(G)); (DST)[(SIZE)-1]='\0'; }
#define U61_MACRO_SNPRINTF8(DST,SIZE,FMT,A,B,C,D,E,F,G,H) { memset((DST),0,(SIZE)); snprintf((DST),(SIZE),(FMT),(A),(B),(C),(D),(E),(F),(G),(H)); (DST)[(SIZE)-1]='\0'; }
#define U61_MACRO_SNPRINTF9(DST,SIZE,FMT,A,B,C,D,E,F,G,H,I) { memset((DST),0,(SIZE)); snprintf((DST),(SIZE),(FMT),(A),(B),(C),(D),(E),(F),(G),(H),(I)); (DST)[(SIZE)-1]='\0'; }

#define U61_MACRO_SPRINTF0(DST,FMT) { U61_MACRO_SNPRINTF0((DST),sizeof(DST),(FMT)); }
#define U61_MACRO_SPRINTF1(DST,FMT,A) { U61_MACRO_SNPRINTF1((DST),sizeof(DST),(FMT),(A)); }
#define U61_MACRO_SPRINTF2(DST,FMT,A,B) { U61_MACRO_SNPRINTF2((DST),sizeof(DST),(FMT),(A),(B)); }
#define U61_MACRO_SPRINTF3(DST,FMT,A,B,C) { U61_MACRO_SNPRINTF3((DST),sizeof(DST),(FMT),(A),(B),(C)); }
#define U61_MACRO_SPRINTF4(DST,FMT,A,B,C,D) { U61_MACRO_SNPRINTF4((DST),sizeof(DST),(FMT),(A),(B),(C),(D)); }
#define U61_MACRO_SPRINTF5(DST,FMT,A,B,C,D,E) { U61_MACRO_SNPRINTF5((DST),sizeof(DST),(FMT),(A),(B),(C),(D),(E)); }
#define U61_MACRO_SPRINTF6(DST,FMT,A,B,C,D,E,F) { U61_MACRO_SNPRINTF6((DST),sizeof(DST),(FMT),(A),(B),(C),(D),(E),(F)); }
#define U61_MACRO_SPRINTF7(DST,FMT,A,B,C,D,E,F,G) { U61_MACRO_SNPRINTF7((DST),sizeof(DST),(FMT),(A),(B),(C),(D),(E),(F),(G)); }
#define U61_MACRO_SPRINTF8(DST,FMT,A,B,C,D,E,F,G,H) { U61_MACRO_SNPRINTF8((DST),sizeof(DST),(FMT),(A),(B),(C),(D),(E),(F),(G),(H)); }
#define U61_MACRO_SPRINTF9(DST,FMT,A,B,C,D,E,F,G,H,I) { U61_MACRO_SNPRINTF9((DST),sizeof(DST),(FMT),(A),(B),(C),(D),(E),(F),(G),(H),(I)); }

#endif
