/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   mainmenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: the menu the player gets when he launches the game
 *              the "root" of all menus except the exit menu... 
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "mainmenu.h"
#include "aboutmenu.h"
#include "startmenu.h"
#include "emptymenu.h"
#include "pausingmenu.h"
#include "alonemenu.h"
#include "playeroptionmenu.h"
#include "gameoptionmenu.h"
#include "button.h"
#include "global.h"
#include "scoremenu.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of an empty menu
 */ 
U61_MainMenu::U61_MainMenu(U61_Menu *parent)
  : U61_Menu(parent,"U61 by U-Foot")
{
  add_item(new U61_Button("Quick start"));
  add_item(new U61_Button("Start new game"));
  add_item(new U61_Button("Game Options"));
  add_item(new U61_Button("Player Options"));
  add_item(new U61_Button("About U61"));
  add_item(new U61_Button("Quit"));
  select(0);
}

/*--------------------------------------------------------------------------*/
/*
 * performs an action, since a key press has been recorded
 */
U61_Menu *U61_MainMenu::validate()
{
  U61_Menu *next_menu;

  next_menu=this;

  switch (selection)
    {
    case 0:
      next_menu=new U61_PausingMenu
	(new U61_AloneMenu
	 (new U61_ScoreMenu(this)));
      U61_Global::game.start_quick();
      break;
    case 1:
      next_menu=new U61_StartMenu(this);
      break;
    case 2:
      next_menu=new U61_GameOptionMenu(this);
      break;
    case 3:
      next_menu=new U61_PlayerOptionMenu(this);
      break;
    case 4:
      next_menu=new U61_AboutMenu(this);
      break;
    case 5:
      next_menu=parent_menu;
      break;
    }

  return next_menu;
}
