/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   menu.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: abstract class, parent of all menus. it maintains the menu
 *              state (the selected item) and provides functions to center
 *              it and handle menuitems in a rational way
 */

#ifndef U61_INC_MENU
#define U61_INC_MENU

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "menuitem.h"
#include "const.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_MENU_BOTTOM_MESSAGE_NB          10
#define U61_MENU_BOTTOM_MESSAGE_DELAY        2

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Menu
{
 public:
  U61_Menu(U61_Menu *parent, char *top);
  virtual ~U61_Menu();
    
  U61_Menu *action(int key);
  void mouse_move(int x, int y);
  virtual U61_Menu *validate();
  virtual U61_Menu *back();
  void draw();
  virtual void before_first_draw();
  virtual U61_Menu *poll();
  void select(int num_item);
  virtual void select_up();
  virtual void select_down();
  int get_height(int first, int nb);
  int get_width(int first, int nb);
  void add_item(U61_MenuItem *item);
  void remove_items();
  U61_Menu *get_parent();

  void shade();
  void unshade();
  static void display_info(char *text);

 protected:
  std::vector<U61_MenuItem *> items;
  U61_Menu *parent_menu;    
  int selection;
  char *top_message;
  bool drawn_once;

  static bool shaded;
  bool message_active;

  static unsigned int info_time_limit;
  static char info_text[U61_CONST_STRING_SIZE];

  static int current_bottom_message;
  static int bottom_message_start_time;
  static int bottom_message_width;
  static char *bottom_message[U61_MENU_BOTTOM_MESSAGE_NB];

  void draw_top_message();
  void draw_info();
  void draw_bottom_message();
  void init_bottom_message();
  void draw_ex(bool do_draw,
	       int mouse_x=-1,
	       int mouse_y=-1,
	       bool *mouse_in=NULL,
	       int *mouse_item=NULL,
	       int *mouse_char=NULL);
};

#endif

