/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   menuinput.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: input class which handles menu events from both keyboard
 *              and mouse.
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "completeinput.h"
#include "log.h"
#include "global.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a menu input object
 */ 
U61_MenuInput::U61_MenuInput() : U61_CompleteInput()
{

}

/*--------------------------------------------------------------------------*/
/* 
 * destruction of a menu input object
 */ 
U61_MenuInput::~U61_MenuInput()
{
}

/*--------------------------------------------------------------------------*/
/*
 * Polls the mouse for basic clicks
 */
void U61_MenuInput::poll(int time)
{
  U61_CompleteInput::poll(time);

  poll_mouse();
}

/*--------------------------------------------------------------------------*/
/*
 * Polls the mouse for basic clicks
 */
void U61_MenuInput::poll_mouse()
{
  if (U61_Global::mouse_monitor.left_pressed())
    {
      simulate(CL_KEY_ENTER);
    }
  if (U61_Global::mouse_monitor.right_pressed())
    {
      simulate(CL_KEY_ESCAPE);
    }
}

