/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   mouse.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: utilities to handle the mouse pointer and the mouse messages
 *              in general.
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <stdlib.h>

#include <ClanLib/display.h>

#include "mouse.h"
#include "log.h"
#include "global.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_MOUSE_INIT_POS_COEF 4

/*---------------------------------------------------------------------------
 static vars
 ---------------------------------------------------------------------------*/

int U61_Mouse::last_x=-1;
int U61_Mouse::last_y=-1;

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * Hides the mouse cursor. It's important to call this before changing and/or
 * shutting down a video mode, for hiding the cursor seems to stop the
 * separate thread which is associated to it for display.
 */
void U61_Mouse::hide()
{
  if (U61_Global::data.screen_w>0 &&
      U61_Global::data.screen_h>0)
    {
      if (last_x<0 || 
	  last_y<0 || 
	  last_x>=U61_Global::data.screen_w ||
	  last_y>=U61_Global::data.screen_h)
	{
	  CL_Mouse::set_position(U61_Global::data.screen_w/U61_MOUSE_INIT_POS_COEF,
				 U61_Global::data.screen_h/U61_MOUSE_INIT_POS_COEF);

	}

      last_x = CL_Mouse::get_x();
      last_y = CL_Mouse::get_y();
    }

  CL_MouseCursor::hide();
}

/*--------------------------------------------------------------------------*/
/*
 * Shows the cursor.
 */
void U61_Mouse::show()
{
  CL_MouseCursor::hide();

  if (last_x>=0 && 
      last_y>=0 &&
      last_x<U61_Global::data.screen_w &&
      last_y<U61_Global::data.screen_h)
    {
      CL_Mouse::set_position(last_x,last_y);
    }

  if (U61_Global::data.mouse_cursor != NULL)
    {
      CL_MouseCursor::set_cursor(U61_Global::data.mouse_cursor);
    }

  CL_MouseCursor::show();
}
