/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   mousemonitor.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: This class is responsible for listening to mouse events.
 *              It gets events like move, button press, and maintains 
 *              informations about the mouse. One of its main interest is
 *              to provide a "has_moved" function.
 */

#ifndef U61_INC_MOUSEMONITOR
#define U61_INC_MOUSEMONITOR

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>
#include <ClanLib/signals.h>
#include <ClanLib/display.h>

#include "keydef.h"
#include "config.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_MouseMonitor
{ 
 public:
  U61_MouseMonitor();
  ~U61_MouseMonitor();

  void init();
  void reset();

  int get_x();
  int get_y();
  bool moved(bool acknowledge=true);
  bool left_pressed(bool acknowledge=true);
  bool right_pressed(bool acknowledge=true);

  void acknowledge_move();
  void acknowledge_left_press();
  void acknowledge_right_press();

 protected:
  int x;
  int y;
  bool moved_state;
  bool left_pressed_state;
  bool right_pressed_state;

  CL_Slot slot_move;
  CL_Slot slot_button_press;
  CL_Slot slot_button_release;

  static void on_move(int x, int y);
  static void on_button_press(const CL_Key &key);
  static void on_button_release(const CL_Key &key);
};

#endif

