/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   multiplayermenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this menu is launched "in game" when escape is pressed to
 *              - allow some options to be changed without stopping the game.
 *              - stop the game if wanted 
 *              it is used for local multiplayer games
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "multiplayermenu.h"
#include "pausingmenu.h"
#include "playermenu.h"
#include "soundmenu.h"
#include "graphicsmenu.h"
#include "systemmenu.h"
#include "button.h"
#include "time.h"
#include "global.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of the option menu
 */ 
U61_MultiplayerMenu::U61_MultiplayerMenu(U61_Menu *parent)
  : U61_Menu(parent,"Local multiplayer game running")
{
  add_item(new U61_Button("Stop this game"));
  add_item(new U61_Button("Resume"));
  add_item(new U61_Button("Player 1 options"));
  add_item(new U61_Button("Player 2 options"));
  add_item(new U61_Button("Player 3 options"));
  add_item(new U61_Button("Player 4 options"));
  add_item(new U61_Button("Graphics"));
  add_item(new U61_Button("Sound"));
  add_item(new U61_Button("System"));
  select(0);
}

/*--------------------------------------------------------------------------*/
/*
 * validate is called when the user presses enter
 */
U61_Menu *U61_MultiplayerMenu::validate()
{
  U61_Menu *next_menu;

  next_menu=this;
  switch (selection)
    {
    case 0:
      next_menu=parent_menu;
      U61_Global::game.stop();
      unshade();
      break;
    case 1:
      next_menu=back();
      break;
    case 2:
      next_menu=new U61_PlayerMenu(this, &(U61_Global::config.player[0]));
      break;
    case 3:
      next_menu=new U61_PlayerMenu(this, &(U61_Global::config.player[1]));
      break;
    case 4:
      next_menu=new U61_PlayerMenu(this, &(U61_Global::config.player[2]));
      break;
    case 5:
      next_menu=new U61_PlayerMenu(this, &(U61_Global::config.player[3]));
      break;
    case 6:
      next_menu=new U61_GraphicsMenu(this, &(U61_Global::config));
      break;
    case 7:
      next_menu=new U61_SoundMenu(this, &(U61_Global::config));
      break;
    case 8:
      next_menu=new U61_SystemMenu(this, &(U61_Global::config));
      break;
    }

  return next_menu;
}

/*--------------------------------------------------------------------------*/
/*
 * back to the game
 */
U61_Menu *U61_MultiplayerMenu::back()
{
  U61_Menu *next_menu;

  next_menu=new U61_PausingMenu(this);
  U61_Time::resume();
  U61_Global::game.configure_hot();
  unshade();

  return next_menu;
}

