/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   registeredcurse.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this is a very simple class, used to store information
 *              about the registered curses in the map object.
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "registeredcurse.h"
#include "serial.h"
#include "log.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a registered curse structure
 */ 
U61_RegisteredCurse::U61_RegisteredCurse()
{
  reset();
}

/*--------------------------------------------------------------------------*/
/*
 * Sets the attributes to default values
 */
void U61_RegisteredCurse::reset()
{
  begin=0;
  end=0;
  active=false;
  good=false;
}

/*--------------------------------------------------------------------------*/
/*
 * Serializes a registeredcurse into a byte strem
 */
bool U61_RegisteredCurse::serialize(unsigned char **buffer, unsigned char *buffer_limit)
{
  bool result=true;
  unsigned char *buffer_start=*buffer;

  result=result && U61_Serial::serialize_int(begin,buffer,buffer_limit);
  result=result && U61_Serial::serialize_int(end,buffer,buffer_limit);
  result=result && U61_Serial::serialize_bool(active,buffer,buffer_limit);
  result=result && U61_Serial::serialize_bool(good,buffer,buffer_limit);

  if ((*buffer) - buffer_start != U61_REGISTEREDCURSE_SERIALIZED_SIZE)
    {
      U61_LOG_WARNING("Wrong buffer size for registeredcurse serialization (diff="<<(buffer_start - (*buffer) + U61_REGISTEREDCURSE_SERIALIZED_SIZE)<<")!");
    }

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * Un-serializes a registeredcurse from a byte strem
 */
bool U61_RegisteredCurse::unserialize(unsigned char **buffer, unsigned char *buffer_limit)
{
  bool result=true;
  unsigned char *buffer_start=*buffer;

  result=result && U61_Serial::unserialize_int((int *) &begin,buffer,buffer_limit);
  result=result && U61_Serial::unserialize_int((int *) &end,buffer,buffer_limit);
  result=result && U61_Serial::unserialize_bool(&active,buffer,buffer_limit);
  result=result && U61_Serial::unserialize_bool(&good,buffer,buffer_limit);

  if ((*buffer) - buffer_start != U61_REGISTEREDCURSE_SERIALIZED_SIZE)
    {
      U61_LOG_WARNING("Wrong buffer size for registeredcurse unserialization (diff="<<(buffer_start - (*buffer) + U61_REGISTEREDCURSE_SERIALIZED_SIZE)<<")!");
    }

  return result;
}


