/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   score.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this class holds global scores during a game. It can also
 *              dump the score on the disk and do a bunch of score related
 *              calculus.
 *              Basically the global scores are updated each time a game ends.
 */

#ifndef U61_INC_SCORE
#define U61_INC_SCORE

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "scoreline.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Score
{
 public:
  U61_Score();
  ~U61_Score();

  void reset();
  void register_game(char *name, bool local,
		     int score,
		     unsigned int time,
		     int curse_sent,
		     int curse_received);

  int get_local_size();
  void get_local_info(int i,char **name,int *nb,int *sco,
		      unsigned int *h,
		      unsigned int *m,
		      unsigned int *s);
  void get_best_max_score(char **name,int *val);
  void get_best_avg_score(char **name,int *val);
  void get_best_max_time(char **name,unsigned int *h,
			 unsigned int *m,
			 unsigned int *s);
  void get_best_avg_time(char **name,unsigned int *h,
			 unsigned int *m,
			 unsigned int *s);
  void get_best_avg_curse_sent(char **name,int *val);
  void get_best_avg_curse_received(char **name,int *val);

 protected:
  std::vector<U61_ScoreLine> local;
  std::vector<U61_ScoreLine> remote;
};

#endif
