/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   scoremenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this menu displays informations on who is the best 8-)
 *              it appears at the end of each game. The detailed scores
 *              are dumped on the disk, in a plain text file.
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "scoremenu.h"
#include "text.h"
#include "score.h"
#include "global.h"
#include "macro.h"
#include "log.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of the score menu
 */ 
U61_ScoreMenu::U61_ScoreMenu(U61_Menu *parent) 
  : U61_Menu(parent,"Score summary")
{
}

/*--------------------------------------------------------------------------*/
/*
 * Does the actual construction of the menu
 */
void U61_ScoreMenu::before_first_draw()
{
  char buffer[U61_CONST_STRING_SIZE];
  int n;
  int i;
  char *player;
  int nb_games,score;
  unsigned int h,m,s;
  int val;

  n=U61_Global::score.get_local_size();
  for (i=0;i<n;++i)
    {
      U61_Global::score.get_local_info(i,&player,&nb_games,&score,&h,&m,&s);
      U61_MACRO_SPRINTF3(buffer,"%s : %d rounds %d pts",
			  player,nb_games,score);
      add_item(new U61_Text(buffer));
    }

  add_item(new U61_Text(" "));

  U61_Global::score.get_best_max_score(&player,&val);
  U61_MACRO_SPRINTF2(buffer,"Max score : %s %d",player,val);
  add_item(new U61_Text(buffer));

  U61_Global::score.get_best_avg_score(&player,&val);
  U61_MACRO_SPRINTF2(buffer,"Avg score : %s %d",player,val);
  add_item(new U61_Text(buffer));

  U61_Global::score.get_best_max_time(&player,&h,&m,&s);
  U61_MACRO_SPRINTF4(buffer,"Max time : %s %02d:%02d:%02d",player,h,m,s);
  add_item(new U61_Text(buffer));

  U61_Global::score.get_best_avg_time(&player,&h,&m,&s);
  U61_MACRO_SPRINTF4(buffer,"Avg time : %s %02d:%02d:%02d",player,h,m,s);
  add_item(new U61_Text(buffer));

  U61_Global::score.get_best_avg_curse_sent(&player,&val);
  U61_MACRO_SPRINTF2(buffer,"Avg curse sent : %s %d",player,val);
  add_item(new U61_Text(buffer));

  U61_Global::score.get_best_avg_curse_received(&player,&val);
  U61_MACRO_SPRINTF2(buffer,"Avg curse received : %s %d",player,val);
  add_item(new U61_Text(buffer));

  select(0);
}

/*--------------------------------------------------------------------------*/
/*
 * Function called on a regular basis
 */
U61_Menu *U61_ScoreMenu::poll()
{
  U61_Menu *new_menu;

  new_menu = U61_Menu::poll();

  if (U61_Global::score.get_local_size()==0)
    {
      /*
       * No score lines registered, it's useless to show the menu
       * so we directly jump to the parent menu.
       */
      new_menu=back();
    }

  return new_menu;
}


