/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   serial.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: contains low level functions to (un)serialize various
 *              standard C types in a platform/byte-endianess independant
 *              way.
 */

/*---------------------------------------------------------------------------
  includes
  ---------------------------------------------------------------------------*/

#include "serial.h"
#include "log.h"

/*---------------------------------------------------------------------------
  variants
  ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
  functions
  ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * Serializes an integer into a byte strem
 */
bool U61_Serial::serialize_int(int i, unsigned char **buffer, unsigned char *buffer_limit)
{
  bool result=false;

  if (buffer_limit-(*buffer)>=U61_SERIAL_INT_SERIALIZED_SIZE)
    {
      (*buffer)[0]=0xFF & i;
      (*buffer)[1]=0xFF & i>>8;
      (*buffer)[2]=0xFF & i>>16;
      (*buffer)[3]=0xFF & i>>24;

      (*buffer)+=U61_SERIAL_INT_SERIALIZED_SIZE;
      result=true;
    }
  else
    {
      U61_LOG_WARNING("Buffer too short to serialize int!");
    }

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * Un-serializes an integer from a byte strem
 */
bool U61_Serial::unserialize_int(int *i, unsigned char **buffer, unsigned char *buffer_limit)
{
  bool result=false;

  if (buffer_limit-(*buffer)>=U61_SERIAL_INT_SERIALIZED_SIZE)
    {
      (*i)=((unsigned int) (*buffer)[3])<<24 
	| ((unsigned int) (*buffer)[2])<<16 
	| ((unsigned int) (*buffer)[1])<<8 
	| ((unsigned int) (*buffer)[0]);

      (*buffer)+=U61_SERIAL_INT_SERIALIZED_SIZE;
      result=true;
    }
  else
    {
      U61_LOG_WARNING("Buffer too short to unserialize int!");
    }

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * Serializes an integer into a byte strem
 */
bool U61_Serial::serialize_short(short s, unsigned char **buffer, unsigned char *buffer_limit)
{
  bool result=false;

  if (buffer_limit-(*buffer)>=U61_SERIAL_SHORT_SERIALIZED_SIZE)
    {
      (*buffer)[0]=0xFF & s;
      (*buffer)[1]=0xFF & s>>8;

      (*buffer)+=U61_SERIAL_SHORT_SERIALIZED_SIZE;
      result=true;
    }
  else
    {
      U61_LOG_WARNING("Buffer too short to serialize short!");
    }

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * Un-serializes an integer from a byte strem
 */
bool U61_Serial::unserialize_short(short *s, unsigned char **buffer, unsigned char *buffer_limit)
{
  bool result=false;

  if (buffer_limit-(*buffer)>=U61_SERIAL_SHORT_SERIALIZED_SIZE)
    {
      (*s)=((unsigned short) (*buffer)[1])<<8 
	| ((unsigned short) (*buffer)[0]);

      (*buffer)+=U61_SERIAL_SHORT_SERIALIZED_SIZE;
      result=true;
    }
  else
    {
      U61_LOG_WARNING("Buffer too short to unserialize short!");
    }

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * Serializes an integer into a byte strem
 */
bool U61_Serial::serialize_char(char c, unsigned char **buffer, unsigned char *buffer_limit)
{
  bool result=false;

  if (buffer_limit-(*buffer)>=U61_SERIAL_CHAR_SERIALIZED_SIZE)
    {
      (*buffer)[0]=c;

      (*buffer)+=U61_SERIAL_CHAR_SERIALIZED_SIZE;
      result=true;
    }
  else
    {
      U61_LOG_WARNING("Buffer too short to serialize char!");
    }

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * Un-serializes an integer from a byte strem
 */
bool U61_Serial::unserialize_char(char *c, unsigned char **buffer, unsigned char *buffer_limit)
{
  bool result=false;

  if (buffer_limit-(*buffer)>=U61_SERIAL_CHAR_SERIALIZED_SIZE)
    {
      (*c)=(*buffer)[0];

      (*buffer)+=U61_SERIAL_CHAR_SERIALIZED_SIZE;
      result=true;
    }
  else
    {
      U61_LOG_WARNING("Buffer too short to unserialize char!");
    }

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * Serializes an integer into a byte strem
 */
bool U61_Serial::serialize_bool(bool b, unsigned char **buffer, unsigned char *buffer_limit)
{
  bool result=false;

  if (buffer_limit-(*buffer)>=U61_SERIAL_BOOL_SERIALIZED_SIZE)
    {
      (*buffer)[0]=b ? 1 : 0;

      (*buffer)+=U61_SERIAL_BOOL_SERIALIZED_SIZE;
      result=true;
    }
  else
    {
      U61_LOG_WARNING("Buffer too short to serialize bool!");
    }

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * Un-serializes an integer from a byte strem
 */
bool U61_Serial::unserialize_bool(bool *b, unsigned char **buffer, unsigned char *buffer_limit)
{
  bool result=false;

  if (buffer_limit-(*buffer)>=U61_SERIAL_BOOL_SERIALIZED_SIZE)
    {
      (*b) = (*buffer)[0] ? true : false;

      (*buffer)+=U61_SERIAL_BOOL_SERIALIZED_SIZE;
      result=true;
    }
  else
    {
      U61_LOG_WARNING("Buffer too short to unserialize bool!");
    }

  return result;
}

