/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   serial.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: contains low level functions to (un)serialize various
 *              standard C types in a platform/byte-endianess independant
 *              way.
 */


#ifndef U61_INC_SERIAL
#define U61_INC_SERIAL

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_SERIAL_INT_SERIALIZED_SIZE        4
#define U61_SERIAL_SHORT_SERIALIZED_SIZE      2
#define U61_SERIAL_CHAR_SERIALIZED_SIZE       1
#define U61_SERIAL_BOOL_SERIALIZED_SIZE       1

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Serial
{
public:
    static bool serialize_int(int i, unsigned char **buffer, unsigned char *buffer_limit);
    static bool unserialize_int(int *i, unsigned char **buffer, unsigned char *buffer_limit);
    static bool serialize_short(short s, unsigned char **buffer, unsigned char *buffer_limit);
    static bool unserialize_short(short *s, unsigned char **buffer, unsigned char *buffer_limit);
    static bool serialize_char(char c, unsigned char **buffer, unsigned char *buffer_limit);
    static bool unserialize_char(char *c, unsigned char **buffer, unsigned char *buffer_limit);
    static bool serialize_bool(bool b, unsigned char **buffer, unsigned char *buffer_limit);
    static bool unserialize_bool(bool *b, unsigned char **buffer, unsigned char *buffer_limit);

protected:
};

#endif
