/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   setup.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: utility used to call all ClanLib setup functions 
 *              with one single function call.
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/sound.h>
#include <ClanLib/mikmod.h>

#include "setup.h"
#include "log.h"
#include "platform.h"
#include "script.h"
#include "sound.h"
#include "mouse.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * Initialisation 
 */ 
void U61_Setup::init()
{
  init1();
  init2();
}

/*--------------------------------------------------------------------------*/
/* 
 * De-initialisation
 */ 
void U61_Setup::deinit()
{
  deinit2();
  deinit1();
}

/*--------------------------------------------------------------------------*/
/* 
 * Initialisation (1st part == debug + core)
 */ 
void U61_Setup::init1()
{
  CL_SetupCore::init();
  U61_Log::init();
}

/*--------------------------------------------------------------------------*/
/* 
 * De-initialisation (1st part == debug + core)
 */ 
void U61_Setup::deinit1()
{
  U61_Log::deinit();
  CL_SetupCore::deinit();
}

/*--------------------------------------------------------------------------*/
/* 
 * Initialisation (2nd part == graphics, sound,...)
 */ 
void U61_Setup::init2()
{
  CL_SetupDisplay::init();
  CL_SetupSound::init();
  CL_SetupMikMod::init();
  U61_Script::open();
  U61_Platform::init();
}

/*--------------------------------------------------------------------------*/
/* 
 * De-initialisation (2nd part == graphics, sound,...)
 */ 
void U61_Setup::deinit2()
{
  U61_Mouse::hide();
  U61_Sound::wait_no_playback();
  
  U61_Platform::deinit();
  U61_Script::close();
  CL_SetupMikMod::deinit();
  CL_SetupSound::deinit();
  CL_SetupDisplay::deinit();
}





