/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   socket.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: wrapper on the ClanLib socket object, with error checks
 *              adapted to the way U61 works.
 */


#ifndef U61_INC_SOCKET
#define U61_INC_SOCKET

/*---------------------------------------------------------------------------
  includes
  ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "const.h"

/*---------------------------------------------------------------------------
  constants
  ---------------------------------------------------------------------------*/

#define U61_SOCKET_INVALID -1

#define U61_SOCKET_MODE_CLOSED    0
#define U61_SOCKET_MODE_LISTENING 1
#define U61_SOCKET_MODE_CONNECTED 2

/*---------------------------------------------------------------------------
  classes
  ---------------------------------------------------------------------------*/

class U61_Socket
{
 public:
  U61_Socket();
  ~U61_Socket();

  bool connect(char *host, int port);
  bool listen(int port);
  U61_Socket *accept();

  int send_buf(char *buf, int size);
  int recv_buf(char *buf, int size, bool peek=false);
  bool send_str(char *str, int max);
  bool recv_str(char *str, int max);

  bool is_alive();
  int get_mode();
  int get_sock();
  char *get_host();
  char *get_ip();
  int get_port();

  void close();
  void disable_close_on_delete();

 protected:
  bool alive;
  bool close_on_delete;
  int mode;
  int sock;
  char sock_host[U61_CONST_STRING_SIZE];
  char sock_ip[U61_CONST_STRING_SIZE];
  int sock_port;

  void console_dump(char *data, int size, char *prefix, char *suffix);
};

#endif
