/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   socketbuffer.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: utility class used to hold input/output data in buffered
 *              sockets.
 */


/*---------------------------------------------------------------------------
  includes
  ---------------------------------------------------------------------------*/

#include <stdlib.h>
#include <string.h>

#include "socketbuffer.h"
#include "log.h"
#include "macro.h"

/*---------------------------------------------------------------------------
  variants
  ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
  functions
  ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * Creates a buffer
 */
U61_SocketBuffer::U61_SocketBuffer()
{
  data = NULL;

  reset();
}

/*--------------------------------------------------------------------------*/
/*
 * Destroys a buffer
 */
U61_SocketBuffer::~U61_SocketBuffer()
{
  reset();
}

/*--------------------------------------------------------------------------*/
/*
 * Initializes the object
 */
void U61_SocketBuffer::reset()
{
  if (data)
    {
      free(data);
      data=NULL;
    }
  
  size=0;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns a pointer on the data buffer
 */
char *U61_SocketBuffer::get_data()
{
  return data;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns the size of the buffer
 */
int U61_SocketBuffer::get_size()
{
  return size;
}

/*--------------------------------------------------------------------------*/
/*
 * Appends some data to the buffer
 */
bool U61_SocketBuffer::append(char *d, int s)
{
  int new_size;
  char *new_data;
  bool ok = false;

  if (s<0)
    {
      U61_LOG_DEBUG("Size can't be negative.");
      s=0;
    }

  new_size = size + s;
  if (new_size>0)
    {
      new_data = (char *) malloc(new_size);

      if (new_data)
	{
	  if (size>0)
	    {
	      memcpy(new_data, data, size);
	    }
	  if (s>0)
	    {
	      memcpy(new_data+size, d, s);
	    }
	  reset();
	  
	  size=new_size;
	  data=new_data;
	  
	  ok = true;
	}
      else
	{
	  U61_LOG_ERROR("Unable to allocate memory for socket buffer.");
	}
    }
  else
    {
      reset();
      ok = true;
    }

  return ok;
}

/*--------------------------------------------------------------------------*/
/*
 * Removes data from the buffer
 */
bool U61_SocketBuffer::cut(int s)
{
  int new_size;
  char *new_data;
  bool ok = false;

  if (s<0)
    {
      U61_LOG_DEBUG("Size can't be negative.");
      s=0;
    }

  new_size = size - s;
  if (new_size>0)
    {
      new_data = (char *) malloc(new_size);
      
      if (new_data)
	{
	  memcpy(new_data, data+s, new_size);

	  reset();
	  
	  size=new_size;
	  data=new_data;
	  
	  ok = true;
	}
      else
	{
	  U61_LOG_ERROR("Unable to allocate memory for socket buffer.");
	}
    }
  else
    {
      reset();
      ok = true;
    }

  return ok;
}















