/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   sound.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: all sound playing (except music) are done through this
 *              class. just ask for a "game start" sound and it's there
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "sound.h"
#include "global.h"
#include "log.h"
#include "system.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * plays a sound if sound is enabled!
 */
void U61_Sound::play(CL_SoundBuffer *sound)
{
  int volume;

  volume=U61_Global::config.sound_volume;
  if (volume>0 && sound!=NULL)
    {
      sound->set_volume(2.0*((float) volume)
			/((float) U61_SOUND_VOLUME_MAX));
      sound->play();
    }
}

/*--------------------------------------------------------------------------*/
/*
 * stops a sound being played
 */
void U61_Sound::stop(CL_SoundBuffer *sound)
{
  if (sound!=NULL)
    {
      sound->stop();
    }
}

/*--------------------------------------------------------------------------*/
/*
 * this sound is played when the game starts
 */
void U61_Sound::play_game_start()
{
  play(U61_Global::data.sound_game_start);
}

/*--------------------------------------------------------------------------*/
/*
 * this sound is played when the users navigates into menu items
 */
void U61_Sound::play_menu_move()
{
  play(U61_Global::data.sound_menu_move);
}

/*--------------------------------------------------------------------------*/
/*
 * this sound is played when the user changes its current menu
 */
void U61_Sound::play_menu_validate()
{
  play(U61_Global::data.sound_menu_validate);
}

/*--------------------------------------------------------------------------*/
/*
 * this sound is played when a block touches the ground
 */
void U61_Sound::play_block_touch()
{
  play(U61_Global::data.sound_block_touch);
}

/*--------------------------------------------------------------------------*/
/*
 * this sound is played when the player completes a pattern
 */
void U61_Sound::play_block_pattern()
{
  play(U61_Global::data.sound_block_pattern);
}

/*--------------------------------------------------------------------------*/
/*
 * this sound is played when a player enters the game
 */
void U61_Sound::play_player_start()
{
  play(U61_Global::data.sound_player_start);
}

/*--------------------------------------------------------------------------*/
/*
 * this sound is played when a player receives a curse
 */
void U61_Sound::play_curse_receive()
{
  play(U61_Global::data.sound_curse_receive);
}

/*--------------------------------------------------------------------------*/
/*
 * this sound is played when a player looses
 */
void U61_Sound::play_player_loose()
{
  play(U61_Global::data.sound_player_loose);
}

/*--------------------------------------------------------------------------*/
/*
 * Wait until any played sound is ended. Required when exiting the game,
 * otherwise SetupSound won't "deinit" correctly.
 */
void U61_Sound::wait_no_playback()
{
  stop(U61_Global::data.sound_game_start);
  stop(U61_Global::data.sound_menu_move);
  stop(U61_Global::data.sound_menu_validate);
  stop(U61_Global::data.sound_block_touch);
  stop(U61_Global::data.sound_block_pattern);
  stop(U61_Global::data.sound_player_start);
  stop(U61_Global::data.sound_curse_receive);
  stop(U61_Global::data.sound_player_loose);

  while ((U61_Global::data.sound_game_start &&
	  U61_Global::data.sound_game_start->is_playing()) ||
	 (U61_Global::data.sound_menu_move &&
	  U61_Global::data.sound_menu_move->is_playing()) ||
	 (U61_Global::data.sound_menu_validate &&
	  U61_Global::data.sound_menu_validate->is_playing()) ||
	 (U61_Global::data.sound_block_touch &&
	  U61_Global::data.sound_block_touch->is_playing()) ||
	 (U61_Global::data.sound_block_pattern &&
	  U61_Global::data.sound_block_pattern->is_playing()) ||
	 (U61_Global::data.sound_player_start &&
	  U61_Global::data.sound_player_start->is_playing()) ||
	 (U61_Global::data.sound_curse_receive &&
	  U61_Global::data.sound_curse_receive->is_playing()) ||
	 (U61_Global::data.sound_player_loose &&
	  U61_Global::data.sound_player_loose->is_playing()))
    {
      CL_System::sleep(100);
      U61_System::keep_alive();
    }    
}
