/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   textdisplayer.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: class used to display text on a bitmap. It knows how to
 *              wrap text, align it, and is heavily used by menu items.
 */

#ifndef U61_INC_TEXTDISPLAYER
#define U61_INC_TEXTDISPLAYER

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>
#include <ClanLib/display.h>

#include "letter.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_TEXTDISPLAYER_MAX_W 1000000
#define U61_TEXTDISPLAYER_MAX_H 1000000

#define U61_TEXTDISPLAYER_ALIGN_LEFT    0
#define U61_TEXTDISPLAYER_ALIGN_CENTER  1
#define U61_TEXTDISPLAYER_ALIGN_RIGHT   2

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_TextDisplayer
{
 public:
  U61_TextDisplayer(CL_Font *fnt);
  U61_TextDisplayer(CL_Font *fnt, char *str);
  virtual ~U61_TextDisplayer();

  void draw(int x, 
	    int y,
	    int align=U61_TEXTDISPLAYER_ALIGN_LEFT,
	    int w=U61_TEXTDISPLAYER_MAX_W, 
	    int h=U61_TEXTDISPLAYER_MAX_H);
  void test_mouse(int x, 
		  int y,
		  int align=U61_TEXTDISPLAYER_ALIGN_LEFT,
		  int w=U61_TEXTDISPLAYER_MAX_W, 
		  int h=U61_TEXTDISPLAYER_MAX_H,
		  int mouse_x=-1,
		  int mouse_y=-1,
		  bool *mouse_in=NULL,
		  int *mouse_char=NULL);
  int get_width(int w=U61_TEXTDISPLAYER_MAX_W);
  int get_height(int w=U61_TEXTDISPLAYER_MAX_W);
  void set_text(char *str);
  void put_text(char *buf, int max);
  int get_text_size();

  void enable_dance(int i);
  void disable_dance(int i);
  void enable_blink(int i);
  void disable_blink(int i);

 protected:
  std::vector<U61_Letter> text;    
  CL_Font *font;
  void draw_ex(bool do_draw,
	       int *total_height,
	       int x,
	       int y,
	       int align=U61_TEXTDISPLAYER_ALIGN_LEFT,
	       int w=U61_TEXTDISPLAYER_MAX_W, 
	       int h=U61_TEXTDISPLAYER_MAX_H,
	       int mouse_x=-1,
	       int mouse_y=-1,
	       bool *mouse_in=NULL,
	       int *mouse_char=NULL);
};

#endif
