/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   wwwlist.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this class allows U61 clients to query the meta-server
 *              and get the list of available servers.
 */



#ifndef U61_INC_WWWLIST
#define U61_INC_WWWLIST

/*---------------------------------------------------------------------------
  includes
  ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "const.h"
#include "wwwlistitem.h"
#include "wwwregister.h"

/*---------------------------------------------------------------------------
  constants
  ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
  classes
  ---------------------------------------------------------------------------*/

class U61_WwwList
{
 public:
  U61_WwwList(char *g=U61_CONST_PROGRAM, 
	      char *v=U61_DEF_VERSION,
	      char *h=U61_WWWREGISTER_METASERVER_DEFAULT_HOST,
	      char *u=U61_WWWREGISTER_METASERVER_DEFAULT_URL,
	      int p=U61_WWWREGISTER_METASERVER_DEFAULT_PORT);
  ~U61_WwwList();

  void reset();

  void set_game(char *g);
  void set_version(char *v);
  void set_metaserver_host(char *h);
  void set_metaserver_url(char *u);
  void set_metaserver_port(int p);

  bool is_searching();
  int get_size();
  U61_WwwListItem *get_item(int i);
  bool search(bool force=true);
  static int search_callback(void *data); 
  void cancel();

 protected:
  char game[U61_CONST_METASERVER_GAME_SIZE+1];
  char version[U61_CONST_METASERVER_VERSION_SIZE+1];
  char metaserver_host[U61_CONST_STRING_SIZE];
  char metaserver_url[U61_CONST_STRING_SIZE];
  int metaserver_port;
  bool searching;

  unsigned int last_execute_time;

  CL_Thread *thread;
  //  CL_Mutex mutex;
  std::vector<U61_WwwListItem *> servers;

  void stop_thread();
  void remove_servers();

  bool parser_read_page(char **str);
  bool parser_read_line(char **str);
};

#endif
