/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   wwwlistitem.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: class used by wwwlist to hold the informations about a
 *              server when querying the meta-server.
 */



/*---------------------------------------------------------------------------
  includes
  ---------------------------------------------------------------------------*/

#include "wwwlistitem.h"
#include "macro.h"
#include "log.h"

/*---------------------------------------------------------------------------
  constants
  ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
  functions
  ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a 'www list item' instance
 */ 
U61_WwwListItem::U61_WwwListItem(char *game_address,
				 int game_port,
				 int game_uptime,
				 int game_busy_players,
				 int game_max_players,
				 bool game_password,
				 char *game_comment)
{
  U61_LOG_DEBUG("Creating WwwListItem object: address="<<game_address<<", port="<<game_port<<", uptime="<<game_uptime<<", busy_players="<<game_busy_players<<", max_players="<<game_max_players<<", password="<<game_password<<", comment=\""<<game_comment<<"\"");

  U61_MACRO_STRCPY(address,game_address);  
  port = game_port;
  uptime = game_uptime;
  busy_players = game_busy_players;
  max_players = game_max_players;
  password = game_password;
  U61_MACRO_STRCPY(comment,game_comment);  
}

/*--------------------------------------------------------------------------*/
/* 
 * destruction of a 'www list item' instance
 */ 
U61_WwwListItem::~U61_WwwListItem()
{

}

/*--------------------------------------------------------------------------*/
/* 
 * Returns the address address of a server
 */ 
char *U61_WwwListItem::get_address()
{
  return address;
}

/*--------------------------------------------------------------------------*/
/* 
 * Returns the port of a server
 */ 
int U61_WwwListItem::get_port()
{
  return port;
}

/*--------------------------------------------------------------------------*/
/* 
 * Returns the uptime (in seconds) of a server
 */ 
int U61_WwwListItem::get_uptime()
{
  return uptime;
}

/*--------------------------------------------------------------------------*/
/* 
 * Returns the number of busy players on a server
 */ 
int U61_WwwListItem::get_busy_players()
{
  return busy_players;
}

/*--------------------------------------------------------------------------*/
/* 
 * Returns the max number of players allowed on a server
 */ 
int U61_WwwListItem::get_max_players()
{
  return max_players;
}

/*--------------------------------------------------------------------------*/
/* 
 * Returns the password state of a server
 */ 
bool U61_WwwListItem::get_password()
{
  return password;
}

/*--------------------------------------------------------------------------*/
/* 
 * Returns the comment of a server
 */ 
char *U61_WwwListItem::get_comment()
{
  return comment;
}
