/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   wwwlistitem.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: class used by wwwlist to hold the informations about a
 *              server when querying the meta-server.
 */



#ifndef U61_INC_WWWLISTITEM
#define U61_INC_WWWLISTITEM

/*---------------------------------------------------------------------------
  includes
  ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "const.h"

/*---------------------------------------------------------------------------
  constants
  ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
  classes
  ---------------------------------------------------------------------------*/

class U61_WwwListItem
{
 public:
  U61_WwwListItem(char *game_address,
		  int game_port,
		  int game_uptime,
		  int game_busy_players,
		  int game_max_players,
		  bool game_password,
		  char *game_comment);

  ~U61_WwwListItem();

  char *get_address();
  int get_port();
  int get_uptime();
  int get_busy_players();
  int get_max_players();
  bool get_password();
  char *get_comment();

 protected:
  char address[U61_CONST_METASERVER_ADDRESS_SIZE+1];
  int port;
  int uptime;
  int busy_players;
  int max_players;
  bool password;
  char comment[U61_CONST_METASERVER_COMMENT_SIZE+1];
};

#endif
