------------------------------------------------------------------------------
--                                                                          --
-- U U    6   1            U U   FFF  O   O  TTT                            --
-- U U   6   11   b        U U   F   O O O O  T                             --
-- U U - 66   1   bb  y y  U U - FF  O O O O  T                             --
-- U U   6 6  1   b b  y   U U   F   O O O O  T                             --
--  U     6   1   bb   y    U    F    O   O   T                             --
--                                                                          --
-- U61 is another block based game                                          --
-- Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   --
--                                                                          --
-- This program is free software; you can redistribute it and/or            --
-- modify it under the terms of the GNU General Public License              --
-- as published by the Free Software Foundation; either version 2           --
-- of the License, or (at your option) any later version.                   --
--                                                                          --
-- This program is distributed in the hope that it will be useful,          --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of           --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            --
-- GNU General Public License for more details.                             --
--                                                                          --
-- You should have received a copy of the GNU General Public License        --
-- along with this program; if not, write to the Free Software              --
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA--
--                                                                          --
-- This project is also available on SourceForge  (http://sourceforge.net)  --
------------------------------------------------------------------------------

-- vertical blocks with 3 squares fall. one can translate them and change
-- the colors, but not rotate them. the goal is to have lines or diags
-- of 3 squares of the same color


-- shape definition ----------------------------------------------------------

function user_new_shape(num)
    return num
end 

function user_do_shape(num)
    local nb_colors

    nb_colors=morecolors_get_nb()

    colored_vertical_bar(3,nb_colors,num)
end


-- actions -------------------------------------------------------------------

function user_rotate_left()
    cycle_forward()    
end

function user_rotate_right()
    cycle_backward()    
end

function user_move_left()
    goofy_left()
end

function user_move_right()
    goofy_right()
end

function user_move_down()
    translation_y(1)
end

function user_use_antidote()
    u61_cancel_curse(u61_get_oldest_curse(0))
end

-- pattern match -------------------------------------------------------------

function user_match_pattern(match_count)
    return color_match_pattern(match_count,3)
end

function user_land()

end

function user_square_blown_up(x,y)
    utils_shift_column_down(x,y)
end

-- curse functions  ----------------------------------------------------------

function user_new_curse(num)
    num=mod(num,100)

    if num<10 then
        num=ID_CURSE_ANTIDOTE
    elseif num<50 then
        num=ID_CURSE_MIXEDLINE
    elseif num<60 then
        num=ID_CURSE_GOOFY
    elseif num<80 then
        num=ID_CURSE_CLEAR
    elseif num<90 then
        num=ID_CURSE_WIND
    elseif num<100 then
        num=ID_CURSE_MORECOLORS
    end

    return num
end

function user_do_curse(num,sent)
    if (num==ID_CURSE_ANTIDOTE) then
        antidote_do_curse()
    elseif (num==ID_CURSE_MIXEDLINE) then
        mixedline_do_curse(sent)
    elseif (num==ID_CURSE_GOOFY) then
        goofy_do_curse(sent)
    elseif (num==ID_CURSE_CLEAR) then
        clear_do_curse()
    elseif (num==ID_CURSE_WIND) then
        wind_do_curse(sent)
    elseif (num==ID_CURSE_MORECOLORS) then
        morecolors_do_curse(sent)
    end    
end

function user_get_curse_name(num)
    name="surprise"

    if (num==ID_CURSE_ANTIDOTE) then
        name="antidote"
    elseif (num==ID_CURSE_MIXEDLINE) then
        name="line"
    elseif (num==ID_CURSE_GOOFY) then
        name="goofy"
    elseif (num==ID_CURSE_CLEAR) then
        name="clear"
    elseif (num==ID_CURSE_WIND) then
        name="wind"
    elseif (num==ID_CURSE_MORECOLORS) then
        name="7colors"
    end

    return name
end

-- callback functions --------------------------------------------------------

function user_time_callback_1()
    u61_add_score(1)
end

function user_time_callback_10()
    wind_time_callback()
end

function user_time_callback_100()

end


