/*
 * Copyright (C) 2000 Loic Dachary, Andreas Hochsteger
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* $Id: php3_unac.c,v 1.2 2000/10/17 20:36:55 loic Exp $ */

#if USE_PHP == 3

#include "dl/phpdl.h"
#include "php.h"
#include "internal_functions.h"

#include <errno.h>

#include "unac.h"

DLEXPORT php3_module_entry *get_module(void);

static void php3_info_unac();
static int php3_minit_unac(INIT_FUNC_ARGS);
static void php3_unac_string(INTERNAL_FUNCTION_PARAMETERS);

static function_entry unac_functions[] = {
	{"unac_string",		php3_unac_string,	NULL},
	{NULL, NULL, NULL}
};

static void php3_info_unac() {
	PUTS(
"Strip accents from a string, based on version 1.1.0.
Usage is unac_string(charset, string) that returns the string
argument without accents. 
Example: unac_string(\"iso-8859-1\", \"t\") -> \"ete\".
");
}


static int php3_minit_unac(INIT_FUNC_ARGS) {
	return SUCCESS;
}

static php3_module_entry unac_module_entry = {
	"UNAC",
	unac_functions,
	php3_minit_unac,
	NULL,
	NULL,
	NULL,
	php3_info_unac,
	STANDARD_MODULE_PROPERTIES
};

DLEXPORT php3_module_entry *get_module(void) { return &unac_module_entry; }

/* {{{ proto string unac_string(string charset, string in)
   Returns the unaccented string */
static void php3_unac_string(INTERNAL_FUNCTION_PARAMETERS) {
	pval *charset, *in;
	char *str = 0;
	int str_length = 0;
	if (ARG_COUNT(ht) != 2 || getParameters(ht, 2, &charset, &in) == FAILURE) {
		WRONG_PARAM_COUNT;
	}
	convert_to_string(charset);
	convert_to_string(in);
	if(unac_string(charset->value.str.val,
		       in->value.str.val, in->value.str.len,
		       &str, &str_length) < 0) {
	  php3_error(E_WARNING, "unac_string: failed %s", strerror(errno));
	  RETURN_FALSE;
	}

	RETURN_STRINGL(str, str_length, 1 /* duplicate */);
}
/* }}} */

#endif /* USE_PHP == 3 */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 */
