###############################################################################
#                 Undernet Channel Service Management Script                  #
###############################################################################
# $Id: UndernetCS-IRC.tcl,v 1.2 2001/09/29 18:22:39 Ze Exp $
###############################################################################
# (c) 2001 RICHARD Yann alias Ze <mgm@ifrance.com>                            #
###############################################################################

###############################################################################
# This program is distributed under the GNU General Public Licence            #
#  See the LICENCE file for more information.                                 #
###############################################################################


# UndernetCS:IRC:Send2X
#   Send a request to X.
#   Return: 1 on success,
#           0 otherwise.
proc UndernetCS:IRC:Send2X {arg} {
    global UndernetCS_XAdrSend botnick

    set cmd [string toupper [lindex $arg 0]]
    # Parse cmd to identify login request witch are more important
    if { $cmd == "LOGIN" } {
        putserv "PRIVMSG $UndernetCS_XAdrSend :$arg" "-next"
        return 1
    }
    # Op command is very important when it's for eggdrop ...
    if { $cmd == "OP" } {
        if { [string toupper [lindex $arg 2]] == [string toupper $botnick] } {
            # In theory this script don't send command if not auth so, it's
            # impossible with -next to send "op" before "login" command.
            putserv "PRIVMSG $UndernetCS_XAdrSend :$arg" "-next"
            return 1
        }
    }
    # Theirs command are important use putserv
    set important_cmd "DEOP BAN UNBAN CLEARMODE KICK INVITE"
    if { [lsearch -exact $important_cmd $cmd] != -1 } {
        putserv "PRIVMSG $UndernetCS_XAdrSend :$arg"
        return 1
    }
    # Others command are not important so we use puthelp
    # to send them.
    puthelp "PRIVMSG $UndernetCS_XAdrSend :$arg"
    return 1
}

### EOF ###