
/*
 * unpackfs.h                                                   (jh,30.03.2006)
 */

/*
 *  unpackfs: filesystem with transparent unpacking of archive files
 *  Copyright (C) 2005, 2006  Jochen Hepp <jochen.hepp@gmx.de>
 *
 *  This file is part of unpackfs.
 *
 *  unpackfs is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  unpackfs is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __unpackfs_h__
#define __unpackfs_h__

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#define FUSE_USE_VERSION 22
#define _FILE_OFFSET_BITS 64
#define HAVE_SETXATTR

/* constants */

#define UNPACKFS_MAGICFILE "/etc/magic:" FILE_MAGIC
#define UNPACKFS_DIR_ENTRIES_ADD 100
#define UNPACKFS_CACHE_EXTENSION_LEN_ADD 20
#define UNPACKFS_CONFIG_BUFFERSIZE 256
#define UNPACKFS_CONFIG_ARGC_MAX 35
#define UNPACKFS_UTIL_FILENAME_ADD 20
#define UNPACKFS_PACKER_CACHE_SIZE 1024

/* if autoconf not defines them set default values */
#ifndef PACKAGE_STRING
#	define PACKAGE_STRING "unpackfs 0.0.6"
#endif
#ifndef SYSCONFDIR
#	define SYSCONFDIR "/etc"
#endif


#include <magic.h>
#include <fuse.h>

#ifndef HAVE_DUP2
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
int dup2(int oldfd, int newfd) {
	close(newfd);
	return dup(oldfd);
}
#endif

#ifndef HAVE_STRCASECMP
#ifdef HAVE_STRINGS_H
#	include <strings.h>
#endif
int strcasecmp(const char *s1, const char *s2) {
	return strcmp(s1, s2);
}
#endif


/* structures */

enum unpackfs_magic_unpack_type
{
	UFSMU_NONE = 0,
	UFSMU_FILE_STDOUT = 1,
	UFSMU_FILE = 2,
	UFSMU_DIR = 3
};

struct unpackfs_magic_unpack
{
	struct unpackfs_magic_unpack *ufsmu_next_magic;
	struct unpackfs_magic_unpack *ufsmu_next_unpack;
	const char   *ufsmu_name;
	enum unpackfs_magic_unpack_type ufsmu_type;
	char         *ufsmu_magic_type;
	size_t        ufsmu_magic_type_len;
	const char  **ufsmu_extension;
	const size_t *ufsmu_extension_len;
	const char   *ufsmu_cmd_file;
	const char  **ufsmu_cmd_argv;
	int           ufsmu_cmd_argnr_srcfile;
};

struct unpackfs_magic_unpack_info
{
	struct unpackfs_magic_unpack *ufsmui_packers;
	struct unpackfs_magic_unpack **ufsmui_packers_cache;
	size_t ufsmui_cache_size;
};

enum unpackfs_cache_mode
{
	UFS_EXISTS = 0,
	UFS_NEW = 1
};

struct unpackfs_fuse
{
	struct fuse *ufsf_fuse_handle;
	int          ufsf_control_fd;
	char        *ufsf_mountpoint;
};


/* config.c */

int unpackfs_config_packer(const char *configfile,
                           struct unpackfs_magic_unpack_info **packer_info);
void unpackfs_config_packer_free(struct unpackfs_magic_unpack_info
                                        *packer_info);


/* cache.c */

int unpackfs_cache(const char *path, const char *root, const char *cache,
                   enum unpackfs_cache_mode mode,
                   char **work, char **other, int *cached);


/* fuse_operations.c */

void unpackfs_packer_info_set(struct unpackfs_magic_unpack_info *info);
struct unpackfs_magic_unpack_info *unpackfs_packer_info_get(void);
void unpackfs_magic_set(magic_t magic);
magic_t unpackfs_magic_get(void);
void unpackfs_root_set(const char *root);
void unpackfs_cache_set(const char *cache);


/* fuse_setup.c */

struct unpackfs_fuse *
unpackfs_fuse_mount(struct fuse_operations *op, size_t op_size,
                  char *mountpoint, char *kernel_opts,
                  char *lib_opts, int background);
int unpackfs_fuse_unmount(struct unpackfs_fuse *unpackfs_fuse);


/* magic.c */

magic_t unpackfs_magic_open(void);
void unpackfs_magic_close(magic_t magic);
int unpackfs_magic_file(magic_t magic,
                        struct unpackfs_magic_unpack_info *packer_info,
                        const char *srcfile, const char *dstfile);


/* util.c */

void *xmalloc(size_t size);
void *xrealloc(void *ptr, size_t size);
char *xstrdup(const char *s);
int unpackfs_compare_strings(const void *a, const void *b);
char *unpackfs_string_cat(const char *str1, const char *str2);
char *unpackfs_tmp_template(const char *prefix);
int unpackfs_rmdir_recursive(const char *dir);
size_t unpackfs_cache_key(const char *string, const size_t size);


#endif /* __unpackfs_h__ */

/* --- end --- */

