;;  Procedures for finding package files

;;  Copyright (C) 2013 Aljosha Papsch <misc@rpapsch.de>
;;
;;  This file is part of Upmf.
;;
;;  Upmf is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  Upmf is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with Upmf.  If not, see <http://www.gnu.org/licenses/>.

;; Look in directory via DIRECTORY-STREAM for subdirectory NEEDLE
;; return #t if found
;; #f if not found
(define search-depth-2
  (lambda (parentdir needle directory-stream)
    (let ((current-entry (readdir directory-stream)))
      (if (eof-object? current-entry)
	  #f
	  (begin (if (string-contains current-entry needle)
		     (print-package-stat (load (string-append packagefile-directory
							      "/" parentdir "/"
							      current-entry "/"
							      current-entry ".scm"))))
	  (search-depth-2 parentdir needle directory-stream))))))

;; Search packagefile-directory for occurence of package NEEDLE
;; Prints results on default port
;; NEEDLE has to be the package name only, without the section!
(define search-directories
  (lambda (needle)
    (let* ((directory-stream (opendir packagefile-directory))
	   (child-stream #f))
      (do ((k (readdir directory-stream)))
	  ((eof-object? k))
	(if (or (string=? k ".") (string=? k ".."))
	    (display "")
	    (begin (set! child-stream (opendir (string-append
						packagefile-directory "/" k)))
		   (search-depth-2 k needle child-stream)
		   (closedir child-stream)))
	(set! k (readdir directory-stream))))))

;; Check if package file PACKAGE-STRING exists,
;; if true return the full file name,
;; if false quit
;; If PACKAGE-STRING is the package name only (without the section),
;; search-directories will be executed, which returns no usable result.
(define find-package-file
  (lambda (package-string)
    (let* ((package-name (if (eq? (length (string-split package-string #\/)) 2)
			     (string-split package-string #\/)
			     (list "unknown" package-string)))
	   (pkgdir-stream #f)
	   (pfile (string-append packagefile-directory "/"
				 package-string "/" (list-ref package-name 1) ".scm" )))
      (if (access? pfile R_OK)
	  pfile
	  (if (string=? (list-ref package-name 0) "unknown")
	      (search-directories (list-ref package-name 1))
	      (errormsg (_ "Package file not found for package")
			package-string 'fatal))))))

;; Find package NEEDLE
;; NEEDLE can be the name with or without the section.
(define find-package
  (lambda (needle)
    (let ((package-file (find-package-file needle)))
      (if (string? package-file)
	  (print-package-stat (load package-file))))))
