/* Copyright (C) 2012,2013 Aljosha Papsch <misc@rpapsch.de>

   This file is part of Upmf.

   Upmf is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   Upmf is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with Upmf.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef PACKAGE_H
#define PACKAGE_H

#include <config.h>
#include <libguile.h>

struct upmf_package
{
  SCM name;
  SCM section;
  SCM description;
  SCM license;
  SCM release_list;
};

static scm_t_bits package_tag;

void
init_package_type ();

/* Constructor */
SCM
make_package (SCM name, SCM section, SCM description, SCM license,
	      SCM release_list);

static SCM
mark_package (SCM package);

static int
print_package (SCM package, SCM port, scm_print_state *pstate);

#endif /* PACKAGE_H */
