;;  Copyright (C) 2013 Aljosha Papsch <misc@rpapsch.de>
;;
;;  This file is part of Upmf.
;;
;;  Upmf is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  Upmf is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with Upmf.  If not, see <http://www.gnu.org/licenses/>.

;; Dirty procedure to check if list CHECK-LIST contains only empty
;; lists (e.g. (() () ()) for CHECK-LIST would produce #t
;; or (() "adsf" ())) would produce #f). This procedure is needed
;; because delq and family does not delete the empty lists if the list
;; contains only empty lists.
(define is-full-of-empty?
  (lambda (check-list)
    (let ((cur-pointer 'empty))
      (if (eq? (length check-list) 0) #f
      (begin (do ((k 0 (1+ k)))
		 ((> k (- (length check-list) 1)))
	       (if (eq? (list-ref check-list k) '())
		   (display "")
		   (set! cur-pointer 'not-empty)))
	     (if (eq? cur-pointer 'not-empty)
		 #f
		 #t))))))

(define check-dependencies
  (lambda (dep-list)
      (if (eq? dep-list #f)
	  (statusmsg (_ "No dependencies for this package"))
	  (begin
	    (let ((install-list (make-list (length dep-list))))
	      (statusmsg (_ "Checking dependencies..."))
	      (do ((k 0 (1+ k)))
		  ((> k (- (length dep-list) 1)))
		(validate-package-string (list-ref dep-list k) 'dont-die)
		(let* ((cur-pkg-str (list-ref dep-list k))
		       (package-obj (load-package cur-pkg-str))
		       (release (length (string-split cur-pkg-str #\:))))
		  (if (is-installed? package-obj release)
		      (statusmsg (_ "Dependency installed") cur-pkg-str)
		      (begin (statusmsg (_ "Dependency not installed")
					cur-pkg-str)
			     (list-set! install-list k cur-pkg-str)))))
	      (set! install-list (if (eq? (is-full-of-empty? install-list) #t)
				     '()
				     (delq #f install-list)))
	      (if (> (length install-list) 0)
		  (begin
		    (display (_ "Install missing dependencies? [y,n] "))
		    (if (eq? (read-char) #\y)
			(begin
			  (do ((k 0 (1+ k)))
			      ((> k (- (length install-list) 1)))
			    (install-package (list-ref install-list k))))
			(errormsg (_ "Cannot continue: not all dependencies installed") #f 'fatal)))))))))
