/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.util.Methods;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

class QuaquaDragRecognitionSupport {
    private int motionThreshold;
    private MouseEvent dndArmedEvent;
    private JComponent component;
    private static QuaquaDragRecognitionSupport instance;

    QuaquaDragRecognitionSupport() {
    }

    private static QuaquaDragRecognitionSupport getDragRecognitionSupport() {
        if (instance == null) {
            instance = new QuaquaDragRecognitionSupport();
        }
        return instance;
    }

    public static boolean mousePressed(MouseEvent me) {
        return QuaquaDragRecognitionSupport.getDragRecognitionSupport().mousePressedImpl(me);
    }

    public static MouseEvent mouseReleased(MouseEvent me) {
        return QuaquaDragRecognitionSupport.getDragRecognitionSupport().mouseReleasedImpl(me);
    }

    public static boolean mouseDragged(MouseEvent me, BeforeDrag bd) {
        return QuaquaDragRecognitionSupport.getDragRecognitionSupport().mouseDraggedImpl(me, bd);
    }

    private void clearState() {
        this.dndArmedEvent = null;
        this.component = null;
    }

    private int mapDragOperationFromModifiers(MouseEvent me, TransferHandler th) {
        if (th == null || !SwingUtilities.isLeftMouseButton(me)) {
            return 0;
        }
        return this.convertModifiersToDropAction(me.getModifiersEx(), th.getSourceActions(this.component));
    }

    private boolean mousePressedImpl(MouseEvent me) {
        this.component = (JComponent)me.getSource();
        if (this.mapDragOperationFromModifiers(me, this.component.getTransferHandler()) != 0) {
            block3: {
                try {
                    this.motionThreshold = (Integer)Methods.invokeStatic(DragSource.class, "getDragThreshold");
                }
                catch (NoSuchMethodException ex) {
                    Integer td = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
                    if (td == null) break block3;
                    this.motionThreshold = td;
                }
            }
            this.dndArmedEvent = me;
            return true;
        }
        this.clearState();
        return false;
    }

    private MouseEvent mouseReleasedImpl(MouseEvent me) {
        if (this.dndArmedEvent == null) {
            return null;
        }
        MouseEvent retEvent = null;
        if (me.getSource() == this.component) {
            retEvent = this.dndArmedEvent;
        }
        this.clearState();
        return retEvent;
    }

    private boolean mouseDraggedImpl(MouseEvent me, BeforeDrag bd) {
        TransferHandler th;
        int action;
        if (this.dndArmedEvent == null) {
            return false;
        }
        if (me.getSource() != this.component) {
            this.clearState();
            return false;
        }
        int dx = Math.abs(me.getX() - this.dndArmedEvent.getX());
        int dy = Math.abs(me.getY() - this.dndArmedEvent.getY());
        if ((dx > this.motionThreshold || dy > this.motionThreshold) && (action = this.mapDragOperationFromModifiers(me, th = this.component.getTransferHandler())) != 0) {
            if (bd != null) {
                bd.dragStarting(this.dndArmedEvent);
            }
            th.exportAsDrag(this.component, this.dndArmedEvent, action);
            this.clearState();
        }
        return true;
    }

    private int convertModifiersToDropAction(int modifiersEx, int sourceActions) {
        int dropAction = 0;
        if (0 != (modifiersEx & 0x2200)) {
            dropAction = 1 & sourceActions;
            if (dropAction == 0) {
                dropAction = 2 & sourceActions;
            }
        } else if (0 != (modifiersEx & 0x2200) && 0 != (modifiersEx & 0x100)) {
            dropAction = 0x40000000 & sourceActions;
            if (dropAction == 0) {
                dropAction = 2 & sourceActions;
            }
        } else {
            dropAction = 2 & sourceActions;
            if (dropAction == 0) {
                dropAction = 1 & sourceActions;
            }
        }
        return dropAction;
    }

    public static interface BeforeDrag {
        public void dragStarting(MouseEvent var1);
    }
}

