/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.MessageStream;
import processing.app.debug.RunnerException;
import processing.app.debug.Target;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler
implements MessageConsumer {
    static final String BUGS_URL = "http://code.google.com/p/arduino/issues/list";
    static final String SUPER_BADNESS = "Compiler error, please submit this code to http://code.google.com/p/arduino/issues/list";
    Sketch sketch;
    String buildPath;
    String primaryClassName;
    boolean verbose;
    RunnerException exception;
    boolean firstErrorFound;
    boolean secondErrorFound;

    public boolean compile(Sketch sketch, String string, String string2, boolean bl) throws RunnerException {
        Serializable serializable;
        Object object;
        String string3;
        Serializable serializable2;
        Object object2;
        this.sketch = sketch;
        this.buildPath = string;
        this.primaryClassName = string2;
        this.verbose = bl;
        MessageStream messageStream = new MessageStream(this);
        String string4 = Base.getAvrBasePath();
        Map<String, String> map = Base.getBoardPreferences();
        String string5 = map.get("build.core");
        if (string5 == null) {
            RunnerException runnerException = new RunnerException("No board selected; please choose a board from the Tools > Board menu.");
            runnerException.hideStackTrace();
            throw runnerException;
        }
        if (string5.indexOf(58) == -1) {
            object2 = Base.getTarget();
            serializable2 = new File(new File(((Target)object2).getFolder(), "cores"), string5);
            string3 = ((File)serializable2).getAbsolutePath();
        } else {
            object2 = Base.targetsTable.get(string5.substring(0, string5.indexOf(58)));
            serializable2 = new File(((Target)object2).getFolder(), "cores");
            object = new File((File)serializable2, string5.substring(string5.indexOf(58) + 1));
            string3 = ((File)object).getAbsolutePath();
        }
        object2 = new ArrayList();
        serializable2 = new ArrayList();
        serializable2.add(string3);
        object = string + File.separator + "core.a";
        List<File> list = this.compileFiles(string4, string, (List<File>)((Object)serializable2), Compiler.findFilesInPath(string3, "S", true), Compiler.findFilesInPath(string3, "c", true), Compiler.findFilesInPath(string3, "cpp", true), map);
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(string4 + "avr-ar", "rcs", object));
        for (File arrayList3 : list) {
            serializable = new ArrayList<String>(arrayList2);
            serializable.add((String)arrayList3.getAbsolutePath());
            this.execAsynchronously((List)((Object)serializable));
        }
        for (File file : sketch.getImportedLibraries()) {
            serializable2.add(file.getPath());
        }
        for (File file : sketch.getImportedLibraries()) {
            serializable = new File(string, file.getName());
            File file2 = new File(file, "utility");
            Compiler.createFolder(serializable);
            serializable2.add(file2.getAbsolutePath());
            object2.addAll(this.compileFiles(string4, ((File)serializable).getAbsolutePath(), (List<File>)((Object)serializable2), Compiler.findFilesInFolder(file, "S", false), Compiler.findFilesInFolder(file, "c", false), Compiler.findFilesInFolder(file, "cpp", false), map));
            serializable = new File((File)serializable, "utility");
            Compiler.createFolder((File)serializable);
            object2.addAll(this.compileFiles(string4, ((File)serializable).getAbsolutePath(), (List<File>)((Object)serializable2), Compiler.findFilesInFolder(file2, "S", false), Compiler.findFilesInFolder(file2, "c", false), Compiler.findFilesInFolder(file2, "cpp", false), map));
            serializable2.remove(serializable2.size() - 1);
        }
        object2.addAll(this.compileFiles(string4, string, (List<File>)((Object)serializable2), Compiler.findFilesInPath(string, "S", false), Compiler.findFilesInPath(string, "c", false), Compiler.findFilesInPath(string, "cpp", false), map));
        ArrayList<String> arrayList4 = new ArrayList<String>(Arrays.asList(string4 + "avr-gcc", "-Os", "-Wl,--gc-sections", "-mmcu=" + map.get("build.mcu"), "-o", string + File.separator + string2 + ".elf"));
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            serializable = (File)iterator.next();
            arrayList4.add(((File)serializable).getAbsolutePath());
        }
        arrayList4.add((String)object);
        arrayList4.add("-L" + string);
        arrayList4.add("-lm");
        this.execAsynchronously(arrayList4);
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string4 + "avr-objcopy", "-O", "-R"));
        serializable = new ArrayList<String>(arrayList);
        serializable.add(2, "ihex");
        serializable.set(3, "-j");
        serializable.add(".eeprom");
        serializable.add("--set-section-flags=.eeprom=alloc,load");
        serializable.add("--no-change-warnings");
        serializable.add("--change-section-lma");
        serializable.add(".eeprom=0");
        serializable.add(string + File.separator + string2 + ".elf");
        serializable.add(string + File.separator + string2 + ".eep");
        this.execAsynchronously((List)((Object)serializable));
        serializable = new ArrayList<String>(arrayList);
        serializable.add(2, "ihex");
        serializable.add(".eeprom");
        serializable.add(string + File.separator + string2 + ".elf");
        serializable.add(string + File.separator + string2 + ".hex");
        this.execAsynchronously((List)((Object)serializable));
        return true;
    }

    private List<File> compileFiles(String string, String string2, List<File> list, List<File> list2, List<File> list3, List<File> list4, Map<String, String> map) throws RunnerException {
        String string3;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : list2) {
            string3 = string2 + File.separator + file.getName() + ".o";
            arrayList.add(new File(string3));
            this.execAsynchronously(Compiler.getCommandCompilerS(string, list, file.getAbsolutePath(), string3, map));
        }
        for (File file : list3) {
            string3 = string2 + File.separator + file.getName() + ".o";
            arrayList.add(new File(string3));
            this.execAsynchronously(Compiler.getCommandCompilerC(string, list, file.getAbsolutePath(), string3, map));
        }
        for (File file : list4) {
            string3 = string2 + File.separator + file.getName() + ".o";
            arrayList.add(new File(string3));
            this.execAsynchronously(Compiler.getCommandCompilerCPP(string, list, file.getAbsolutePath(), string3, map));
        }
        return arrayList;
    }

    private void execAsynchronously(List list) throws RunnerException {
        Process process;
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        int n = 0;
        if (this.verbose || Preferences.getBoolean("build.verbose")) {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.print(stringArray[i] + " ");
            }
            System.out.println();
        }
        this.firstErrorFound = false;
        this.secondErrorFound = false;
        try {
            process = Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            RunnerException runnerException = new RunnerException(iOException.getMessage());
            runnerException.hideStackTrace();
            throw runnerException;
        }
        MessageSiphon messageSiphon = new MessageSiphon(process.getInputStream(), this);
        MessageSiphon messageSiphon2 = new MessageSiphon(process.getErrorStream(), this);
        boolean bl = true;
        while (bl) {
            try {
                if (messageSiphon.thread != null) {
                    messageSiphon.thread.join();
                }
                if (messageSiphon2.thread != null) {
                    messageSiphon2.thread.join();
                }
                n = process.waitFor();
                bl = false;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (n > 1) {
            System.err.println(stringArray[0] + " returned " + n);
        }
        if (n != 0) {
            RunnerException runnerException = new RunnerException("Error compiling.");
            runnerException.hideStackTrace();
            throw runnerException;
        }
    }

    @Override
    public void message(String string) {
        String string2;
        String[] stringArray;
        if (!this.verbose) {
            int n;
            while ((n = string.indexOf(this.buildPath + File.separator)) != -1) {
                string = string.substring(0, n) + string.substring(n + (this.buildPath + File.separator).length());
            }
        }
        if ((stringArray = PApplet.match((String)string, (String)(string2 = "([\\w\\d_]+.\\w+):(\\d+):\\s*error:\\s*(.*)\\s*"))) != null) {
            RunnerException runnerException = this.sketch.placeException(stringArray[3], stringArray[1], PApplet.parseInt((String)stringArray[2]) - 1);
            if (runnerException != null && !this.verbose) {
                SketchCode sketchCode = this.sketch.getCode(runnerException.getCodeIndex());
                String string3 = sketchCode.isExtension(this.sketch.getDefaultExtension()) ? sketchCode.getPrettyName() : sketchCode.getFileName();
                string = string3 + ":" + runnerException.getCodeLine() + ": error: " + runnerException.getMessage();
            }
            if (stringArray[3].trim().equals("SPI.h: No such file or directory")) {
                runnerException = new RunnerException("Please import the SPI library from the Sketch > Import Library menu.");
                string = string + "\nAs of Arduino 0019, the Ethernet library depends on the SPI library.\nYou appear to be using it or another library that depends on the SPI library.";
            }
            if (this.exception == null && runnerException != null) {
                this.exception = runnerException;
                this.exception.hideStackTrace();
            }
        }
        System.err.print(string);
    }

    private static List getCommandCompilerS(String string, List list, String string2, String string3, Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string + "avr-gcc", "-c", "-g", "-assembler-with-cpp", "-mmcu=" + map.get("build.mcu"), "-DF_CPU=" + map.get("build.f_cpu"), "-DARDUINO=21"));
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add("-I" + (String)list.get(i));
        }
        arrayList.add(string2);
        arrayList.add("-o" + string3);
        return arrayList;
    }

    private static List getCommandCompilerC(String string, List list, String string2, String string3, Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string + "avr-gcc", "-c", "-g", "-Os", "-w", "-ffunction-sections", "-fdata-sections", "-mmcu=" + map.get("build.mcu"), "-DF_CPU=" + map.get("build.f_cpu"), "-DARDUINO=21"));
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add("-I" + (String)list.get(i));
        }
        arrayList.add(string2);
        arrayList.add("-o" + string3);
        return arrayList;
    }

    private static List getCommandCompilerCPP(String string, List list, String string2, String string3, Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string + "avr-g++", "-c", "-g", "-Os", "-w", "-fno-exceptions", "-ffunction-sections", "-fdata-sections", "-mmcu=" + map.get("build.mcu"), "-DF_CPU=" + map.get("build.f_cpu"), "-DARDUINO=21"));
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add("-I" + (String)list.get(i));
        }
        arrayList.add(string2);
        arrayList.add("-o" + string3);
        return arrayList;
    }

    private static void createFolder(File file) throws RunnerException {
        if (file.isDirectory()) {
            return;
        }
        if (!file.mkdir()) {
            throw new RunnerException("Couldn't create: " + file);
        }
    }

    public static String[] headerListFromIncludePath(String string) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".h");
            }
        };
        return new File(string).list(filenameFilter);
    }

    public static ArrayList<File> findFilesInPath(String string, String string2, boolean bl) {
        return Compiler.findFilesInFolder(new File(string), string2, bl);
    }

    public static ArrayList<File> findFilesInFolder(File file, String string, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.listFiles() == null) {
            return arrayList;
        }
        for (File file2 : file.listFiles()) {
            if (file2.getName().startsWith(".")) continue;
            if (file2.getName().endsWith("." + string)) {
                arrayList.add(file2);
            }
            if (!bl || !file2.isDirectory()) continue;
            arrayList.addAll(Compiler.findFilesInFolder(file2, string, true));
        }
        return arrayList;
    }
}

