/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.Theme;

public class EditorStatus
extends JPanel {
    static Color[] bgcolor;
    static Color[] fgcolor;
    static final int NOTICE = 0;
    static final int ERR = 1;
    static final int EDIT = 2;
    static final int YES = 1;
    static final int NO = 2;
    static final int CANCEL = 3;
    static final int OK = 4;
    static final String NO_MESSAGE = "";
    Editor editor;
    int mode;
    String message;
    Font font;
    FontMetrics metrics;
    int ascent;
    Image offscreen;
    int sizeW;
    int sizeH;
    int imageW;
    int imageH;
    JButton cancelButton;
    JButton okButton;
    JTextField editField;
    int response;

    public EditorStatus(Editor editor) {
        this.editor = editor;
        this.empty();
        if (bgcolor == null) {
            bgcolor = new Color[3];
            EditorStatus.bgcolor[0] = Theme.getColor("status.notice.bgcolor");
            EditorStatus.bgcolor[1] = Theme.getColor("status.error.bgcolor");
            EditorStatus.bgcolor[2] = Theme.getColor("status.edit.bgcolor");
            fgcolor = new Color[3];
            EditorStatus.fgcolor[0] = Theme.getColor("status.notice.fgcolor");
            EditorStatus.fgcolor[1] = Theme.getColor("status.error.fgcolor");
            EditorStatus.fgcolor[2] = Theme.getColor("status.edit.fgcolor");
        }
    }

    public void empty() {
        this.mode = 0;
        this.message = NO_MESSAGE;
        this.repaint();
    }

    public void notice(String string) {
        this.mode = 0;
        this.message = string;
        this.repaint();
    }

    public void unnotice(String string) {
        if (this.message.equals(string)) {
            this.empty();
        }
    }

    public void error(String string) {
        this.mode = 1;
        this.message = string;
        this.repaint();
    }

    public void edit(String string, String string2) {
        this.mode = 2;
        this.message = string;
        this.response = 0;
        this.okButton.setVisible(true);
        this.cancelButton.setVisible(true);
        this.editField.setVisible(true);
        this.editField.setText(string2);
        this.editField.selectAll();
        this.editField.requestFocus();
        this.repaint();
    }

    public void unedit() {
        this.okButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.editField.setVisible(false);
        this.empty();
    }

    public void paintComponent(Graphics graphics) {
        if (this.okButton == null) {
            this.setup();
        }
        Dimension dimension = this.getSize();
        if (dimension.width != this.sizeW || dimension.height != this.sizeH) {
            if (dimension.width > this.imageW || dimension.height > this.imageH) {
                this.offscreen = null;
            } else {
                this.sizeW = dimension.width;
                this.sizeH = dimension.height;
                this.setButtonBounds();
            }
        }
        if (this.offscreen == null) {
            this.sizeW = dimension.width;
            this.sizeH = dimension.height;
            this.setButtonBounds();
            this.imageW = this.sizeW;
            this.imageH = this.sizeH;
            this.offscreen = this.createImage(this.imageW, this.imageH);
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        if (this.font == null) {
            this.font = Theme.getFont("status.font");
            graphics2.setFont(this.font);
            this.metrics = graphics2.getFontMetrics();
            this.ascent = this.metrics.getAscent();
        }
        graphics2.setColor(bgcolor[this.mode]);
        graphics2.fillRect(0, 0, this.imageW, this.imageH);
        graphics2.setColor(fgcolor[this.mode]);
        graphics2.setFont(this.font);
        graphics2.drawString(this.message, 6, (this.sizeH + this.ascent) / 2);
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    protected void setup() {
        if (this.okButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.okButton = new JButton("OK");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (EditorStatus.this.mode == 2) {
                        EditorStatus.this.unedit();
                    }
                }
            });
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (EditorStatus.this.mode == 2) {
                        String string = EditorStatus.this.editField.getText();
                        EditorStatus.this.editor.getSketch().nameCode(string);
                        EditorStatus.this.unedit();
                    }
                }
            });
            if (Base.isMacOS()) {
                this.cancelButton.setBackground(bgcolor[2]);
                this.okButton.setBackground(bgcolor[2]);
            }
            this.setLayout(null);
            this.add(this.cancelButton);
            this.add(this.okButton);
            this.cancelButton.setVisible(false);
            this.okButton.setVisible(false);
            this.editField = new JTextField();
            this.editField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() == '\u001b') {
                        EditorStatus.this.unedit();
                        keyEvent.consume();
                    }
                }

                public void keyTyped(KeyEvent keyEvent) {
                    char c = keyEvent.getKeyChar();
                    if (c == '\n') {
                        String string = EditorStatus.this.editField.getText();
                        EditorStatus.this.editor.getSketch().nameCode(string);
                        EditorStatus.this.unedit();
                        keyEvent.consume();
                    } else if (c != '\b' && c != '\u007f' && c != '\'' && c != '%' && c != '&' && c != '(' && c != '$' && c != '#' && c != '\u0010') {
                        if (c == ' ') {
                            String string = EditorStatus.this.editField.getText();
                            int n = EditorStatus.this.editField.getSelectionStart();
                            int n2 = EditorStatus.this.editField.getSelectionEnd();
                            EditorStatus.this.editField.setText(string.substring(0, n) + "_" + string.substring(n2));
                            EditorStatus.this.editField.setCaretPosition(n + 1);
                            keyEvent.consume();
                        } else if (!(c == '_' || c == '.' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                            if (c >= '0' && c <= '9') {
                                if (EditorStatus.this.editField.getCaretPosition() == 0 || EditorStatus.this.editField.getSelectionStart() == 0) {
                                    keyEvent.consume();
                                }
                            } else {
                                keyEvent.consume();
                            }
                        }
                    }
                }
            });
            this.add(this.editField);
            this.editField.setVisible(false);
        }
    }

    protected void setButtonBounds() {
        int n = (this.sizeH - Preferences.BUTTON_HEIGHT) / 2;
        int n2 = 6 + Preferences.BUTTON_WIDTH;
        int n3 = this.sizeW - n2;
        int n4 = n3 - n2;
        int n5 = n4 - n2;
        this.cancelButton.setLocation(n3, n);
        this.okButton.setLocation(n4, n);
        this.cancelButton.setSize(Preferences.BUTTON_WIDTH, Preferences.BUTTON_HEIGHT);
        this.okButton.setSize(Preferences.BUTTON_WIDTH, Preferences.BUTTON_HEIGHT);
        int n6 = 2 * Preferences.BUTTON_WIDTH;
        int n7 = this.editField.getPreferredSize().height;
        int n8 = (1 + this.sizeH - n7) / 2;
        this.editField.setBounds(n5 - Preferences.BUTTON_WIDTH, n8, n6, n7);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(300, 33);
    }

    public Dimension getMaximumSize() {
        return new Dimension(3000, 33);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelButton) {
            if (this.mode == 2) {
                this.unedit();
            }
        } else if (actionEvent.getSource() == this.okButton && this.mode == 2) {
            String string = this.editField.getText();
            this.editor.getSketch().nameCode(string);
            this.unedit();
        }
    }
}

