/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Sketch;
import processing.app.tools.Tool;

public class Archiver
implements Tool {
    Editor editor;
    boolean useDate;
    int digits = 3;
    NumberFormat numberFormat;
    SimpleDateFormat dateFormat;

    public String getMenuTitle() {
        return "Archive Sketch";
    }

    public void init(Editor editor) {
        this.editor = editor;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setMinimumIntegerDigits(this.digits);
        this.dateFormat = new SimpleDateFormat("yyMMdd");
    }

    public void run() {
        String string;
        Object object;
        Sketch sketch = this.editor.getSketch();
        boolean bl = false;
        try {
            bl = sketch.save();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!bl) {
            Base.showWarning("Couldn't archive sketch", "Archiving the sketch has been canceled because\nthe sketch couldn't save properly.", null);
            return;
        }
        File file = sketch.getFolder();
        String string2 = file.getName();
        File file2 = new File(file.getParent());
        File file3 = null;
        String string3 = null;
        int n = 0;
        do {
            boolean bl2 = this.useDate = !string2.startsWith("sketch_");
            if (this.useDate) {
                object = this.dateFormat.format(new Date());
                string = (String)object + (char)(97 + n);
                string3 = string2 + "-" + string;
                file3 = new File(file2, string3 + ".zip");
            } else {
                object = this.numberFormat.format(n + 1);
                string3 = string2 + "-" + (String)object;
                file3 = new File(file2, string3 + ".zip");
            }
            ++n;
        } while (file3.exists());
        object = new FileDialog((Frame)this.editor, "Archive sketch as:", 1);
        ((FileDialog)object).setDirectory(file2.getAbsolutePath());
        ((FileDialog)object).setFile(file3.getName());
        ((Dialog)object).setVisible(true);
        string = ((FileDialog)object).getDirectory();
        String string4 = ((FileDialog)object).getFile();
        if (string4 != null) {
            file3 = new File(string, string4);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
                this.buildZip(file, string2, zipOutputStream);
                zipOutputStream.flush();
                zipOutputStream.close();
                this.editor.statusNotice("Created archive " + file3.getName() + ".");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            this.editor.statusNotice("Archive sketch canceled.");
        }
    }

    public void buildZip(File file, String string, ZipOutputStream zipOutputStream) throws IOException {
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            ZipEntry zipEntry;
            String string2;
            if (stringArray[i].equals(".") || stringArray[i].equals("..")) continue;
            File file2 = new File(file, stringArray[i]);
            String string3 = string2 = string == null ? stringArray[i] : string + "/" + stringArray[i];
            if (file2.isDirectory()) {
                zipEntry = new ZipEntry(string2 + "/");
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.closeEntry();
                this.buildZip(file2, string2, zipOutputStream);
                continue;
            }
            zipEntry = new ZipEntry(string2);
            zipEntry.setTime(file2.lastModified());
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(Base.loadBytesRaw(file2));
            zipOutputStream.closeEntry();
        }
    }
}

