/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import processing.app.Base;
import processing.app.Editor;
import processing.app.tools.Tool;
import processing.core.PFont;

public class CreateFont
extends JFrame
implements Tool {
    Editor editor;
    Dimension windowSize;
    JList fontSelector;
    JTextField sizeSelector;
    JCheckBox allBox;
    JCheckBox smoothBox;
    JTextArea sample;
    JButton okButton;
    JTextField filenameField;
    Hashtable table;
    boolean smooth = true;
    boolean all = false;
    Font font;
    String[] list;
    int selection = -1;

    public CreateFont() {
        super("Create Font");
    }

    public String getMenuTitle() {
        return "Create Font...";
    }

    public void init(Editor editor) {
        this.editor = editor;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(13, 13, 13, 13));
        container.add((Component)jPanel, "Center");
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        String string = "Use this tool to create bitmap fonts for your program.\nSelect a font and size, and click 'OK' to generate the font.\nIt will be added to the data folder of the current sketch.";
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setBorder(new EmptyBorder(10, 10, 20, 10));
        jTextArea.setBackground(null);
        jTextArea.setEditable(false);
        jTextArea.setHighlighter(null);
        jTextArea.setFont(new Font("Dialog", 0, 12));
        jPanel.add(jTextArea);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        String[] stringArray = new String[fontArray.length];
        this.table = new Hashtable();
        int n = 0;
        for (int i = 0; i < fontArray.length; ++i) {
            stringArray[n++] = fontArray[i].getPSName();
            this.table.put(fontArray[i].getPSName(), fontArray[i]);
        }
        this.list = new String[n];
        System.arraycopy(stringArray, 0, this.list, 0, n);
        this.fontSelector = new JList<String>(this.list);
        this.fontSelector.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    CreateFont.this.selection = CreateFont.this.fontSelector.getSelectedIndex();
                    CreateFont.this.okButton.setEnabled(true);
                    CreateFont.this.update();
                }
            }
        });
        this.fontSelector.setSelectionMode(0);
        this.fontSelector.setVisibleRowCount(12);
        JScrollPane jScrollPane = new JScrollPane(this.fontSelector);
        jPanel.add(jScrollPane);
        Dimension dimension = new Dimension(13, 13);
        jPanel.add(new Box.Filler(dimension, dimension, dimension));
        this.sample = new JTextArea("The quick brown fox blah blah."){

            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, CreateFont.this.smooth ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                super.paintComponent(graphics2D);
            }
        };
        this.sample.setFont(new Font("Dialog", 0, 12));
        jPanel.add(this.sample);
        Dimension dimension2 = new Dimension(6, 6);
        jPanel.add(new Box.Filler(dimension2, dimension2, dimension2));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Size:"));
        this.sizeSelector = new JTextField(" 48 ");
        this.sizeSelector.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                CreateFont.this.update();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                CreateFont.this.update();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        jPanel2.add(this.sizeSelector);
        this.smoothBox = new JCheckBox("Smooth");
        this.smoothBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateFont.this.smooth = CreateFont.this.smoothBox.isSelected();
                CreateFont.this.update();
            }
        });
        this.smoothBox.setSelected(this.smooth);
        jPanel2.add(this.smoothBox);
        this.allBox = new JCheckBox("All Characters");
        this.allBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateFont.this.all = CreateFont.this.allBox.isSelected();
            }
        });
        this.allBox.setSelected(this.all);
        jPanel2.add(this.allBox);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel("Filename:"));
        this.filenameField = new JTextField(20);
        jPanel3.add(this.filenameField);
        jPanel3.add(new JLabel(".vlw"));
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateFont.this.setVisible(false);
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateFont.this.build();
            }
        });
        this.okButton.setEnabled(false);
        jPanel4.add(jButton);
        jPanel4.add(this.okButton);
        jPanel.add(jPanel4);
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setDefaultButton(this.okButton);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateFont.this.setVisible(false);
            }
        };
        Base.registerWindowCloseKeys(jRootPane, actionListener);
        Base.setIcon(this);
        this.pack();
        this.sample.setFont(new Font(this.list[0], 0, 48));
        this.fontSelector.setSelectedIndex(0);
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        this.windowSize = this.getSize();
        this.setLocation((dimension3.width - this.windowSize.width) / 2, (dimension3.height - this.windowSize.height) / 2);
    }

    public void run() {
        this.setVisible(true);
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.windowSize.width, 2000);
    }

    public Dimension getMinimumSize() {
        return this.windowSize;
    }

    public void update() {
        int n = 0;
        try {
            n = Integer.parseInt(this.sizeSelector.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n > 0 && n < 256 && this.selection != -1) {
            Font font = (Font)this.table.get(this.list[this.selection]);
            this.font = font.deriveFont(0, n);
            this.sample.setFont(this.font);
            String string = this.list[this.selection].replace(' ', '_');
            string = string + "-" + n;
            this.filenameField.setText(string);
        }
    }

    public void build() {
        int n = 0;
        try {
            n = Integer.parseInt(this.sizeSelector.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n <= 0) {
            JOptionPane.showMessageDialog(this, "Bad font size, try again.", "Badness", 2);
            return;
        }
        String string = this.filenameField.getText();
        if (string.length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter a file name for the font.", "Lameness", 2);
            return;
        }
        if (!string.endsWith(".vlw")) {
            string = string + ".vlw";
        }
        try {
            Font font = (Font)this.table.get(this.list[this.selection]);
            this.font = font.deriveFont(0, n);
            PFont pFont = new PFont(this.font, this.smooth, this.all ? null : PFont.DEFAULT_CHARSET);
            File file = this.editor.getSketch().prepareDataFolder();
            pFont.save((OutputStream)new FileOutputStream(new File(file, string)));
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "An error occurred while creating font.", "No font for you", 2);
            iOException.printStackTrace();
        }
        this.setVisible(false);
    }
}

