#   Copyright (c) 2007 Axel Wachtler
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   * Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#   * Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   * Neither the name of the authors nor the names of its contributors
#     may be used to endorse or promote products derived from this software
#     without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
#   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
#   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
#   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
#   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
#   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
#   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
#   POSSIBILITY OF SUCH DAMAGE.

# $Id: makerelease.sh,v 1.20 2010/01/20 20:23:08 awachtler Exp $

##
# This script builds two release packages
#  - uracoli*-src.tgz ... the source code only package
#  - uracoli*.tgz ....... package with precompiled documentation + source code
#
# Usage:
#   bash Tools/makerelease.sh <tagname>
#
#  <tagname> = snap : current HEAD is packed
#             X.Y.Z : is translated into cvs tagname  "r_X_Y_Z"
#                     X,Y,Z must be numeric values
#

#RELBASE=/tmp/uracoli-release
RELBASE=release
MODULE=uracoli
REPOSITORY=":pserver:anonymous@cvs.savannah.nongnu.org:/sources/uracoli"
rel=$1
RELTAG=$(echo $rel | sed -n 's/\([0-9]\+\)\.\([0-9]\+\)\.\([0-9]\+\)\([a-z]*\)/r_\1_\2_\3/p')
SRC_EXCLUDE="--exclude=Src/App/Wavr109 --exclude=dbgenv.sh"


if [ "x$1" == "x" ] ;  then
    echo "Give a release Number"
    exit 2000
fi
if [ "x$1" == "xsnap" ] ;  then
    rel=$(date +"cvs%Y%m%d")
    RELTAG="HEAD"
fi

RELDIR=${MODULE}-${rel}

test -d ${RELBASE} || mkdir -p ${RELBASE}

cd ${RELBASE} && \
cvs -z3 -d ${REPOSITORY}  export -r${RELTAG} -d${RELDIR} ${MODULE} && \

zip -r ${RELDIR}-src.zip ${RELDIR}/ && \
scons -C ${RELDIR} version=$rel all arduino doc && \
scons -C ${RELDIR} -c clean && \
avr-strip -g ${RELDIR}/install/lib/*${i}*.a

zip -r ${RELDIR}-doc.zip ${RELDIR}/install/doc

for i in rdk psk stb rbb wdba tiny230 rz mnb900 zgb rfa;
do
    zip -r ${RELDIR}-${i}.zip \
              ${RELDIR}/install/inc \
              ${RELDIR}/install/bin/*${i}*hex \
              ${RELDIR}/install/lib/*${i}*.a \
              ${RELDIR}/install/xmpl/*.[hc]
done


(cd ${RELDIR}/install/arduino-0017-uracoli ; zip -r  ../arduino-0017-uracoli.zip . )

for i in ${RELDIR}-*; do echo put $i; done > putfile


echo "Created $RELDIR in ${RELBASE}"
