/* Copyright (c) 2007 Axel Wachtler
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id: board_dummy.h,v 1.1 2008/03/21 11:14:27 awachtler Exp $ */
/**
 * @file
 * @brief Dummy board definition for (board type) with (CPU type).
 *
 * Take this file as a template for a new board implementation.
 */
/**
 * @ingroup grpBoardCfg */
/**@{*/


/*%*
 *
 * @defgroup grp<brD> ....
 * @brief .....
 *
 * @ingroup grpBoard
 *
 * The wiring of the radio and the AT.... is shown below:
*
<pre>
     AVR      RF230
     ---      -----
     Pxx  -->  SLPTR
     Pxx  <--  MCLK
     Pxx  <--  IRQ (INT2)
     Pxx  -->  RSTN
     Pxx  -->  SS
     Pxx  -->  MOSI
     Pxx  <--  MISO
     Pxx  -->  SCK

     <other peripherals>
</pre>
 */
/** ID String for this hardware */
#define BOARD_NAME_<brd> "<brd>"

#ifndef BOARD_DUMMY_H
#define BOARD_DUMMY_H

#define BOARD_TYPE (<brd>)              /**< current board type (see const.h)*/
#define BOARD_NAME BOARD_NAME_<brd>     /**< current board name */

/*=== Compile time parameters ========================================*/
#ifndef MAX_FRAME_SIZE
# define MAX_FRAME_SIZE (127) /**< maximum allowed frame size */
#endif

#ifndef F_CPU
# error "F_CPU is undefined"
#endif

#ifndef DEFAULT_SPI_RATE
# define DEFAULT_SPI_RATE  (SPI_RATE_1_2)
#endif

/*=== Hardware Components ============================================*/
#define CPU_TYPE   (CPU_...)            /**< used CPU (see const.h)*/
#define RADIO_TYPE (RADIO_AT86RF230)    /**< used radiio (see const.h)*/

/*=== TRX pin access macros ==========================================*/

#define DDR_TRX_RESET   DDR...          /**< DDR register for RESET pin */
#define PORT_TRX_RESET  PORT...         /**< PORT register for RESET pin */
#define MASK_TRX_RESET  (_BV(...))      /**< PIN mask for RESET pin */

#define PORT_TRX_SLPTR  PORT...         /**< DDR register for SLEEP_TR pin */
#define DDR_TRX_SLPTR   DDR...          /**< PORT register for SLEEP_TR pin */
#define MASK_TRX_SLPTR  (_BV(PB...))    /**< PIN mask for SLEEP_TR pin */

/*=== IRQ access macros ==============================================*/
# define TRX_IRQ         _BV(INT...)    /**< interrupt mask for GICR */
# define TRX_IRQ_vect    INT..._vect    /**< interrupt vector name */

/** configuration of interrupt handling */
# define TRX_IRQ_INIT()  do{\
                            MCUCSR  |= _BV(ISC...);\
                          } while(0) /** rising edge triggers INT... */

/** disable TRX interrupt */
#define DI_TRX_IRQ() {GICR... &= (~(TRX_IRQ));}
/** enable TRX interrupt */
#define EI_TRX_IRQ() {GICR... |= (TRX_IRQ);}

/*=== SPI access macros ==============================================*/
#define SPI_TYPE  SPI_TYPE_SPI
#define DDR_SPI  (DDR...)   /**< DDR register for SPI port */
#define PORT_SPI (PORT...)  /**< PORT register for SPI port */

#define SPI_MOSI _BV(P...)  /**< PIN mask for MOSI pin */
#define SPI_MISO _BV(P...)  /**< PIN mask for MISO pin */
#define SPI_SCK  _BV(P...)  /**< PIN mask for SCK pin */
#define SPI_SS   _BV(P...)  /**< PIN mask for SS pin */

#define SPI_DATA_REG SPDR...    /**< abstraction for SPI data register */


/**
 * @brief inline function for SPI initialization
 */
static inline void SPI_INIT(uint8_t spirate)
{
    /* first configure SPI Port, then SPCR */
    DDR_SPI  |= SPI_MOSI | SPI_SCK | SPI_SS;
    DDR_SPI  &= ~SPI_MISO;
    PORT_SPI |= SPI_SCK | SPI_SS;

    SPCR = (_BV(SPE) | _BV(MSTR));

    SPCR &= ~(_BV(SPR1) | _BV(SPR0) );
    SPSR &= ~_BV(SPI2X);

    SPCR |= (spirate & 0x03);
    SPSR |= ((spirate >> 2) & 0x01);

}

/** set SS line to low level */
#define SPI_SELN_LOW()       uint8_t sreg = SREG; cli(); PORT_SPI &=~SPI_SS
/** set SS line to high level */
#define SPI_SELN_HIGH()      PORT_SPI |= SPI_SS; SREG = sreg
/** wait until SPI transfer is ready */
#define SPI_WAITFOR()        do { while((SPSR & _BV(SPIF)) == 0);} while(0)

/*=== LED access macros ==============================================*/
#define NO_LEDS       (1)        /**< if defined, no LEDs are connected */
#define PORT_LED      PORT.      /**< PORT register for LEDs */
#define DDR_LED       DDR.       /**< DDR register for LEDs */
#define MASK_LED      (0x..)     /**< MASK value for LEDs (msb aligned)*/
#define SHIFT_LED     (.)        /**< SHIFT value for LEDs */
#define INVERSE_LEDS  (.)        /**< = 1, if low level at port
                                      means LED on */


/*=== KEY access macros ==============================================*/
#define NO_KEYS       (1)        /**< if defined, no KEYS are connected */
#define PORT_KEY      PORT.      /**< PORT register for keys */
#define PIN_KEY       PIN.       /**< PIN register for keys */
#define DDR_KEY       DDR.       /**< DDR register for keys */
#define MASK_KEY      (0x..)     /**< MASK value for keys (msb aligned) */
#define SHIFT_KEY     (.)        /**< SHIFT value for keys */
#define INVERSE_KEYS  (.)        /**< = 1, if low level at port
                                      means KEY pressed */

/*=== Host Interface ================================================*/
#define HIF_TYPE    HIF_.

/*=== TIMER Interface ===============================================*/
#define NO_TIMER (1)
#define TIMER_TICK ( (0xFFFFUL * 1000.0 )/ F_CPU) /** tick value in ms*/
#define TIMER_POOL_SIZE  (0)
#define TIMER_INIT()     ...
#define TIMER_IRQ_vect   ...


/*=== OSCCAL tuning =================================================*/
#ifndef TUNED_OSCCAL
# define TUNED_OSCCAL (0xbf)  /* default is 0xb1, but @2.9V 0xbf is better */
#endif
#endif /*BOARD_DUMMY_H*/
