/* Copyright (c) 2007 Axel Wachtler
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id: trx_rf230.h,v 1.1 2008/03/21 11:14:28 awachtler Exp $ */
/**
 * @file
 * @brief AT86RF230 Transceiver access function interface.
 *
 */

#ifndef TRX_RF230_H
#define TRX_RF230_H

/* === Includes ============================================================== */

/* === Externals ============================================================= */

/* === Types ================================================================= */

/** Data Type for Transceiver SRAM address
 * @ingroup grpTrx
 */
typedef uint8_t trx_ramaddr_t;

/** Data Type for Transceiver register value
 * @ingroup grpTrx
 */
typedef uint8_t trx_regval_t;

/** Data Type for Transceiver register address
 * @ingroup grpTrx
 */
typedef uint8_t trx_regaddr_t;

/* === Macros ================================================================ */


#define TRX_CMD_RW           (_BV(7) | _BV(6))
#define TRX_CMD_RR           (_BV(7))
#define TRX_CMD_FW           (_BV(6) | _BV(5))
#define TRX_CMD_FR           (_BV(5))
#define TRX_CMD_SW           (_BV(6))
#define TRX_CMD_SR           (0)
#define TRX_CMD_RADDR_MASK   (0x3f)

#define TRX_RESET_TIME_US    (6)

#define TRX_IRQ_CAUSE      IRQcause
#define TRX_IRQ_CNT        IRQcnt

/** Mask for PLL lock interrupt
 * @ingroup grpTrx
 */
#define TRX_IRQ_PLL_LOCK   _BV(0)

/** Mask for PLL unlock interrupt
 * @ingroup grpTrx
 */
#define TRX_IRQ_PLL_UNLOCK _BV(1)

/** Mask for RX Start interrupt
 * @ingroup grpTrx
 */
#define TRX_IRQ_RX_START   _BV(2)

/** Mask for RX/TX end interrupt
 * @ingroup grpTrx
 */
#define TRX_IRQ_TRX_END    _BV(3)

/** Mask for RX/TX underrun interrupt
 * @ingroup grpTrx
 */
#define TRX_IRQ_UR         _BV(6)

/** Mask for battery low interrupt
 * @ingroup grpTrx
 */
#define TRX_IRQ_BAT_LOW    _BV(7)

/* === Prototypes ============================================================ */
#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* TRX_RF230_H */
