/* Copyright (c) 2007 Axel Wachtler
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id: trx_rf230_param.c,v 1.1 2008/03/21 11:14:31 awachtler Exp $ */
/**
 * @file
 * @brief ....
 * @_addtogroup grpApp...
 */


/* === includes ============================================================ */
#include <stdlib.h>
#include <avr/pgmspace.h>
#include <avr/eeprom.h>
#include <util/crc16.h>
#include "board.h"
#include "transceiver.h"

#if RADIO_TYPE == RADIO_AT86RF230 || defined(DOXYGEN)

/* === macros ============================================================== */

/* === types =============================================================== */

/* === globals ============================================================= */

/* === prototypes ========================================================== */

/* === functions =========================================================== */
uint16_t crc_compute_block(uint8_t *p, size_t sz)
{
    uint16_t crc = 0;
    while (sz--)
    {
        crc = _crc_ccitt_update(crc, *p++);
    }
    return crc;
}

void trx_parms_get(trx_param_t *p)
{
    p->chan = trx_bit_read(SR_CHANNEL);
    p->txp  = trx_bit_read(SR_TX_PWR);
    p->cca  = trx_bit_read(SR_CCA_MODE);
    p->clkm = trx_bit_read(SR_CLKM_CTRL);
    p->crc = crc_compute_block((uint8_t*)p, sizeof(trx_param_t)-sizeof(uint16_t));
}

uint8_t trx_parms_set(trx_param_t *p, bool no_crc_check)
{
uint8_t ret;
uint16_t crc;

    ret = 1;
    crc = 0;
    if (no_crc_check == false)
    {
        crc = crc_compute_block((uint8_t*)p, sizeof(trx_param_t));
    }
    if (crc == 0)
    {
        trx_bit_write(SR_CHANNEL, p->chan);
        trx_bit_write(SR_TX_PWR, p->txp);
        trx_bit_write(SR_CCA_MODE, p->cca);
        #ifdef CLKM_CHANGE_SAVE
        # error "not yet implemented"
        #else
            trx_bit_write(SR_CLKM_CTRL, p->clkm);
        #endif
        ret = 0;
    }
    return ret;
}

trx_cfg_t trx_parms_read(const void * eeparm, const void * flashparm, trx_param_t *p)
{

trx_cfg_t ret = CFG_NONE;
uint16_t crc;

    /* first try eeprom */
    if (eeparm != 0)
    {
        eeprom_read_block(p, eeparm, sizeof(trx_param_t));
        crc = crc_compute_block((uint8_t*)p, sizeof(trx_param_t));
        if (crc == 0)
        {
            ret = CFG_EEPROM;
        }
    }

    if ((flashparm != 0) &&(ret == CFG_NONE))
    {
        memcpy_P(p, flashparm, sizeof(trx_param_t));
        crc = crc_compute_block((uint8_t*)p, sizeof(trx_param_t));
        if (crc == 0)
        {
            ret = CFG_FLASH;
        }
    }
    return ret;
}

trx_cfg_t trx_parms_write(const void * eeparm, trx_param_t *p)
{
uint16_t crc;
trx_cfg_t ret;
    ret = CFG_NONE;
    if (eeparm != 0)
    {
        crc = crc_compute_block((uint8_t*)p, (sizeof(trx_param_t) - sizeof(crc)));
        p->crc = crc;
        eeprom_write_block(p, (void*)eeparm, sizeof(trx_param_t));
        ret = CFG_EEPROM;
    }
    return ret;
}

#endif /* RADIO_TYPE == AT86RF230 */
/* EOF */
