#   Copyright (c) 2007 Axel Wachtler
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   * Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#   * Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   * Neither the name of the authors nor the names of its contributors
#     may be used to endorse or promote products derived from this software
#     without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
#   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
#   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
#   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
#   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
#   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
#   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
#   POSSIBILITY OF SUCH DAMAGE.

# $Id: wuarttest.py,v 1.1 2008/03/21 11:14:35 awachtler Exp $

import serial, threading, traceback, md5, time, copy, sys
from diagradio import Device

try:
    import readline, rlcompleter
    readline.parse_and_bind("tab:complete")
except:
    print "No libreadline support"
    traceback.print_exc()


d0 = Device("d0","/dev/ttyUSB0", 38400)
d1 = Device("d1","/dev/ttyUSB1", 38400)



def test_rxtx(n=10):
    mtx = md5.md5()
    mrx = md5.md5()
    # clean buffers
    d0.r(2000)
    d1.r(2000)
    rxdata =""
    txdata =""
    f = open("/dev/urandom")
    for i in xrange(n):
        if i % (n/10) == 0:
            print "\b+",
            sys.stdout.flush()
        d = f.read(16)
        d0.w(d)
        txdata += d
        mtx.update(d)
        r = d1.r(64)
        rxdata += r
        mrx.update(r)
        if mtx.digest() != mrx.digest():
            print "Mismatch after %d sz=%d/%d bytes " % (i,len(txdata),len(rxdata))
            raise "ErrorRxTx"
    print
    print "tx sz=%d, md5=%r" % (len(txdata), mtx.hexdigest())
    print "rx sz=%d, md5=%r" % (len(rxdata), mrx.hexdigest())
    return (txdata,rxdata)

