/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.Serial;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.RunnerException;

public abstract class Uploader
implements MessageConsumer {
    static final String BUGS_URL = "https://developer.berlios.de/bugs/?group_id=3590";
    static final String SUPER_BADNESS = "Compiler error, please submit this code to https://developer.berlios.de/bugs/?group_id=3590";
    RunnerException exception;
    static InputStream serialInput;
    static OutputStream serialOutput;
    boolean firstErrorFound;
    boolean secondErrorFound;
    boolean notFoundError;

    public abstract boolean uploadUsingPreferences(String var1, String var2) throws RunnerException;

    public abstract boolean burnBootloader(String var1) throws RunnerException;

    protected void flushSerialBuffer() throws RunnerException {
        try {
            Serial serial = new Serial();
            while (serial.available() > 0) {
                byte[] byArray = serial.readBytes();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            serial.setDTR(false);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            serial.setDTR(true);
            serial.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RunnerException(exception.getMessage());
        }
    }

    protected boolean executeUploadCommand(Collection collection) throws RunnerException {
        this.firstErrorFound = false;
        this.secondErrorFound = false;
        this.notFoundError = false;
        int n = 0;
        String string = System.getProperty("user.dir") + File.separator;
        try {
            String[] stringArray = new String[collection.size()];
            collection.toArray(stringArray);
            String string2 = Base.isLinux() ? new String(Base.getHardwarePath() + "/tools/") : new String(Base.getHardwarePath() + "/tools/avr/bin/");
            stringArray[0] = string2 + stringArray[0];
            if (Preferences.getBoolean("upload.verbose")) {
                for (int i = 0; i < stringArray.length; ++i) {
                    System.out.print(stringArray[i] + " ");
                }
                System.out.println();
            }
            Process process = Runtime.getRuntime().exec(stringArray);
            new MessageSiphon(process.getInputStream(), this);
            new MessageSiphon(process.getErrorStream(), this);
            boolean bl = true;
            while (bl) {
                try {
                    n = process.waitFor();
                    bl = false;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.exception != null) {
                this.exception.hideStackTrace();
                throw this.exception;
            }
            if (n != 0) {
                return false;
            }
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            if (string3 != null && string3.indexOf("uisp: not found") != -1 && string3.indexOf("avrdude: not found") != -1) {
                return false;
            }
            exception.printStackTrace();
            n = -1;
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (n != 0 && n != 1) {
            this.exception = new RunnerException(SUPER_BADNESS);
        }
        return n == 0;
    }

    public void message(String string) {
        System.err.print(string);
        if (string.indexOf("Error") != -1) {
            this.notFoundError = true;
            return;
        }
        if (this.notFoundError) {
            this.exception = new RunnerException("the selected serial port " + string + " does not exist or your board is not connected");
            return;
        }
        if (string.indexOf("Device is not responding") != -1) {
            this.exception = new RunnerException("Device is not responding, check the right serial port is selected or RESET the board right before exporting");
            return;
        }
        if (string.indexOf("Programmer is not responding") != -1 || string.indexOf("programmer is not responding") != -1 || string.indexOf("protocol error") != -1) {
            this.exception = new RunnerException("Problem uploading to board.  See http://www.arduino.cc/en/Guide/Troubleshooting#upload for suggestions.");
            return;
        }
        if (string.indexOf("Expected signature") != -1) {
            this.exception = new RunnerException("Wrong microcontroller found.  Did you select the right board from the Tools > Board menu?");
            return;
        }
    }
}

