/* Copyright (c) 2009 Axel Wachtler
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id$ */
/** Example for Lightweight Mesh, first node (sending) */

/* === includes ============================================================ */
#include "board.h"
#include "xmpl_lw_mesh.h"
#include "lw_mesh.h"
#include "timer.h"

/* === macros ============================================================== */

/* === types =============================================================== */

/* === globals ============================================================= */
static NWK_DataReq_t request;
uint8_t message[] = {'h','e','l','l','o',' ','u','r','a','c','o','l','i','!'};

/* === prototypes ========================================================== */

/* === functions =========================================================== */
static void app_data_confirm(NWK_DataReq_t *req)
{
	uint8_t i;

    if(req->status == NWK_SUCCESS_STATUS)
    {
        /* frame was sent successfully */
    }
    else
    {
        /* some error occurred */
    	LED_SET(1);
        for(i=0;i<5;i++){
        	LED_TOGGLE(1);
        	DELAY_MS(60);
        }

        /* now LED is off */
    }
}

static void app_task_handler()
{
    /* do some application specific things */
}

static time_t send_data_request()
{
    /* send a network frame every LW_XMPLE_FRAME_INTERVAL */
    lw_mesh_data_req(&request);
    LED_TOGGLE(0);
    return MSEC(LW_XMPL_TX_FRAME_INTERVAL);
}

int main(void)
{
    /* This will stop the application before initializing the radio transceiver
     * (ISP issue with MISO pin, see FAQ)
     */
    trap_if_key_pressed();

    /* init LEDs */
    LED_INIT();
    LED_SET_VALUE(LED_MAX_VALUE);
    DELAY_MS(20);
    LED_SET_VALUE(0);

    /* init radio and lw_mesh and enable global interrupts */
    lw_mesh_init(PANID, TX_SHORT_ADDR, CHANNEL);
    sei();

    /* prepare data request */
    request.dstAddr     = RX_SHORT_ADDR;
    request.dstEndpoint = RX_ENDPOINT_ID;
    request.srcEndpoint = TX_ENDPOINT_ID;
    request.options     = 0;
    request.data        = message;
    request.size        = sizeof(message);
    request.confirm     = app_data_confirm;

    /* send network frames every LW_XMPLE_FRAME_INTERVAL,
     * timer_init is called already during lw_mesh_init */
    timer_start(send_data_request, MSEC(LW_XMPL_TX_FRAME_INTERVAL), 0);

    while(1)
    {
        lw_mesh_task_handler();
        app_task_handler();
    }
}
/* EOF */

